/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.setup;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.core.search.Query;
import info.magnolia.cms.core.search.QueryManager;
import info.magnolia.cms.core.search.QueryResult;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractTask;
import info.magnolia.module.delta.TaskExecutionException;
import java.util.Collection;
import javax.jcr.RepositoryException;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;

public class RemoveResolutionsNodeTask
extends AbstractTask {
    public RemoveResolutionsNodeTask() {
        super("Remove resolutions nodes", "Remove resolutions nodes which type is not mgnl:resolutions");
    }

    public void execute(InstallContext installContext) throws TaskExecutionException {
        HierarchyManager hm = installContext.getHierarchyManager("media");
        QueryManager mgr = hm.getQueryManager();
        try {
            Query query = mgr.createQuery("//resolutions", "xpath");
            QueryResult result = query.execute();
            Collection resolutions = result.getContent(ItemType.CONTENTNODE.getSystemName());
            for (Content node : resolutions) {
                if (node.isNodeType(MediaConfigurationManager.RESOLUTIONS.getSystemName())) continue;
                hm.delete(node.getHandle());
            }
            hm.save();
        }
        catch (RepositoryException ex) {
            throw new TaskExecutionException(ex.getMessage(), (Throwable)ex);
        }
    }
}

