/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.setup;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.core.NodeData;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractRepositoryTask;
import info.magnolia.module.delta.TaskExecutionException;
import java.util.Collection;
import javax.jcr.RepositoryException;

public class MoveHandlerNodedataToNode
extends AbstractRepositoryTask {
    public MoveHandlerNodedataToNode() {
        super("Update mediatype configuration", "Handler configuration now requires a node instead of a nodedata");
    }

    protected void doExecute(InstallContext installContext) throws RepositoryException, TaskExecutionException {
        Content types = installContext.getConfigHierarchyManager().getContent("/modules/media/mediatypes");
        Collection mediatypes = types.getChildren(ItemType.CONTENTNODE);
        String handlerPropertyName = "handler";
        for (Content mediatype : mediatypes) {
            if (!mediatype.hasNodeData(handlerPropertyName)) continue;
            this.log.info("Legacy configuration found for mediatype {}", (Object)(mediatype.getName() + ", updating configuration"));
            NodeData handlerNd = mediatype.getNodeData(handlerPropertyName);
            String previousHandler = handlerNd.getString();
            handlerNd.delete();
            if (mediatype.hasContent(handlerPropertyName)) continue;
            mediatype.createContent(handlerPropertyName, ItemType.CONTENTNODE).createNodeData("class", (Object)previousHandler);
        }
    }
}

