/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.save;

import info.magnolia.cms.beans.runtime.MultipartForm;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.security.AccessDeniedException;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.context.MgnlContext;
import info.magnolia.module.admininterface.FieldSaveHandler;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaTypeConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaCustomSaveHandler
implements FieldSaveHandler {
    private Logger log = LoggerFactory.getLogger(MediaCustomSaveHandler.class);

    public void save(Content parentNode, Content configNode, String name, MultipartForm form, int type, int valueType, int isRichEditValue, int encoding) throws RepositoryException, AccessDeniedException {
        HttpServletRequest request = MgnlContext.getWebContext().getRequest();
        String value = request.getParameter(name);
        if (StringUtils.isBlank((String)value)) {
            for (String property : new String[]{name, name + "_width", name + "_height"}) {
                if (!parentNode.hasNodeData(property) || parentNode.getNodeData(property).getType() == 2) continue;
                parentNode.deleteNodeData(property);
            }
            return;
        }
        HierarchyManager hm = MgnlContext.getHierarchyManager((String)"media");
        try {
            Content media = hm.getContentByUUID(value);
            MediaTypeConfiguration mtc = MediaConfigurationManager.getInstance().getMediaTypeConfigurationFromMedia(media);
            mtc.getHandler().onSavingPropertyMedia(media, parentNode, configNode, name, request, form, type, valueType, isRichEditValue, encoding);
        }
        catch (ItemNotFoundException e) {
            this.log.warn("Missing media {} referenced in node {}", (Object)value, (Object)parentNode.getHandle());
        }
        boolean resizing = NodeDataUtil.getBoolean((Content)configNode, (String)"resizing", (boolean)false);
        for (String dimKey : new String[]{"width", "height"}) {
            String paramName = name + '_' + dimKey;
            long dimValue = NumberUtils.toLong((String)request.getParameter(paramName), (long)-1L);
            if (resizing && dimValue >= 0L) {
                NodeDataUtil.getOrCreateAndSet((Content)parentNode, (String)paramName, (long)dimValue);
                continue;
            }
            if (!parentNode.hasNodeData(paramName)) continue;
            parentNode.deleteNodeData(paramName);
        }
    }
}

