/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.processors;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Map;
import net.sourceforge.openutils.mgnlmedia.media.processors.BaseImageResolutionProcessor;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FitInAndFillWithBandsImageResolutionProcessor
extends BaseImageResolutionProcessor {
    private Logger log = LoggerFactory.getLogger(FitInAndFillWithBandsImageResolutionProcessor.class);

    @Override
    public BufferedImage getImageForResolution(BufferedImage original, int x, int y, Map<String, String> parameters) {
        Color color = null;
        String hexColor = parameters.get("background");
        if (StringUtils.isNotBlank((String)hexColor)) {
            try {
                hexColor = "0x" + (hexColor.startsWith("#") ? hexColor.substring(1) : hexColor);
                color = Color.decode(hexColor);
            }
            catch (NumberFormatException e) {
                this.log.error("Invalid color code: " + hexColor, (Throwable)e);
            }
        }
        return this.fitIn(original, x, y, color);
    }
}

