/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.processors;

import java.awt.Color;
import java.awt.image.BufferedImage;
import net.sourceforge.openutils.mgnlmedia.media.processors.ImageResolutionProcessor;
import net.sourceforge.openutils.mgnlmedia.media.utils.ImageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseImageResolutionProcessor
implements ImageResolutionProcessor {
    private Logger log = LoggerFactory.getLogger(BaseImageResolutionProcessor.class);

    public BufferedImage fitIn(BufferedImage original, int x, int y) {
        return this.resizeInOut(original, x, y, false, null);
    }

    public BufferedImage fitIn(BufferedImage original, int x, int y, Color background) {
        return this.resizeInOut(original, x, y, true, background);
    }

    protected BufferedImage resizeInOut(BufferedImage original, int x, int y, boolean fit, Color background) {
        if (original == null) {
            throw new IllegalArgumentException("input image is null");
        }
        float oX = original.getWidth();
        float oY = original.getHeight();
        if (oX < 1.0f || oY < 1.0f) {
            throw new IllegalArgumentException("Broken input image (width=" + oX + ",height=" + oY + ")");
        }
        double xRatio = (double)x / (double)oX;
        double yRatio = (double)y / (double)oY;
        if (xRatio * yRatio == 1.0) {
            this.log.debug("Nothing to resize, return original");
            return original;
        }
        double ratio = Math.min(xRatio, yRatio);
        int newX = (int)Math.round((double)oX * ratio);
        int newY = (int)Math.round((double)oY * ratio);
        return ImageUtils.resizeImage(original, newX, newY, fit ? x : newX, fit ? y : newY, background);
    }

    public BufferedImage fill(BufferedImage original, int x, int y, boolean cropCentered) {
        int oWidth = original.getWidth();
        int oHeight = original.getHeight();
        if (x == oWidth && y == oHeight) {
            return original;
        }
        float oX = oWidth;
        float oY = oHeight;
        float oDelta = oX / oY;
        float delta = (float)x / (float)y;
        if (oDelta >= delta) {
            int newX = (int)((float)y * oX / oY);
            BufferedImage filled = ImageUtils.resizeImage(original, newX, y);
            return cropCentered ? ImageUtils.cropImage(filled, (newX - x) / 2, 0, x, y) : filled;
        }
        int newY = (int)((float)x * oY / oX);
        BufferedImage filled = ImageUtils.resizeImage(original, x, newY);
        return cropCentered ? ImageUtils.cropImage(filled, 0, (newY - y) / 2, x, y) : filled;
    }
}

