/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.pages;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.core.Path;
import info.magnolia.cms.core.SystemProperty;
import info.magnolia.cms.exchange.ActivationManagerFactory;
import info.magnolia.cms.exchange.ExchangeException;
import info.magnolia.cms.util.AlertUtil;
import info.magnolia.cms.util.ExclusiveWrite;
import info.magnolia.commands.CommandsManager;
import info.magnolia.context.MgnlContext;
import info.magnolia.module.admininterface.commands.ActivationCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaTypeConfiguration;
import net.sourceforge.openutils.mgnlmedia.media.pages.MediaBean;
import net.sourceforge.openutils.mgnlmedia.media.pages.MessagesTemplatedMVCHandler;
import net.sourceforge.openutils.mgnlmedia.media.tags.el.MediaEl;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaFolderViewPage
extends MessagesTemplatedMVCHandler {
    public static final String SORT_BY_FILENAME = "filename";
    public static final String SORT_BY_MODIFICATIONDATE = "modificationdate";
    public static final String SORT_BY_USAGE = "usage";
    private Logger log = LoggerFactory.getLogger(MediaFolderViewPage.class);
    private String path;
    private String node;
    private String dest;
    private String type;
    private String sorting;
    private boolean selectMedia;
    private String actMediaHandle;
    private String mediaType;
    private Collection<MediaBean> medias;
    private Collection<MediaTypeConfiguration> types;
    private Map<String, Integer> numberOfMedia;
    private boolean writable;
    private boolean canPublish;
    private boolean develop;
    private String search;

    public MediaFolderViewPage(String name, HttpServletRequest request, HttpServletResponse response) {
        super(name, request, response);
    }

    public void init() {
        super.init();
        if (this.mediaType != null && this.mediaType.length() > 0) {
            String[] mediaTypes = StringUtils.split((String)this.mediaType, (String)",");
            this.type = mediaTypes[0];
            this.types = new ArrayList<MediaTypeConfiguration>();
            for (String mt : mediaTypes) {
                this.types.add(MediaConfigurationManager.getInstance().getTypes().get(mt));
            }
        } else if (this.type == null) {
            this.type = MediaConfigurationManager.getInstance().getTypes().entrySet().iterator().next().getKey();
            this.types = MediaConfigurationManager.getInstance().getTypes().values();
        } else {
            this.types = MediaConfigurationManager.getInstance().getTypes().values();
        }
        if (!StringUtils.isBlank((String)this.path) || !StringUtils.isBlank((String)this.search)) {
            this.fillNumberOfMediaPerType();
        }
        if (this.sorting == null) {
            this.sorting = SORT_BY_MODIFICATIONDATE;
        }
    }

    private void fillNumberOfMediaPerType() {
        this.numberOfMedia = new HashMap<String, Integer>();
        for (MediaTypeConfiguration mtc : this.types) {
            try {
                Collection<Content> c = MediaConfigurationManager.getInstance().find(this.path, mtc.getName(), this.search, StringUtils.isNotBlank((String)this.search));
                this.numberOfMedia.put(mtc.getName(), c.size());
            }
            catch (RepositoryException repositoryException) {}
        }
    }

    public String show() {
        HierarchyManager hm = MgnlContext.getInstance().getHierarchyManager("media");
        final MediaTypeConfiguration mtc = MediaConfigurationManager.getInstance().getTypes().get(this.type);
        Collection<Content> mediasOfType = null;
        this.develop = SystemProperty.getBooleanProperty((String)"magnolia.develop");
        if (!StringUtils.isBlank((String)this.path)) {
            try {
                Content folder = hm.getContent(this.getPath());
                this.writable = folder.isGranted(11L);
                this.canPublish = this.writable && ActivationManagerFactory.getActivationManager().hasAnyActiveSubscriber();
                mediasOfType = MediaConfigurationManager.getInstance().getMediaNodes(folder, this.type, this.sorting);
            }
            catch (RepositoryException ex) {
                this.log.error("Exception caught", (Throwable)ex);
            }
        } else if (!StringUtils.isBlank((String)this.search)) {
            try {
                this.writable = false;
                this.canPublish = false;
                mediasOfType = MediaConfigurationManager.getInstance().find(null, this.type, this.search, true);
            }
            catch (RepositoryException ex) {
                this.log.error("Exception caught", (Throwable)ex);
            }
        }
        this.medias = mediasOfType != null ? Collections2.transform(mediasOfType, (Function)new Function<Content, MediaBean>(){

            public MediaBean apply(Content media) {
                MediaBean mb = new MediaBean();
                mb.setContent(media);
                mb.setMetaData(media.getMetaData());
                mb.setHandle(media.getHandle());
                mb.setFilename(mtc.getHandler().getFilename(media));
                mb.setTitle(mtc.getHandler().getTitle(media));
                mb.setThumbnailUrl(mtc.getHandler().getThumbnailUrl(media));
                mb.setPreviewUrl(mtc.getHandler().getPreviewUrl(media));
                mb.setDescription(mtc.getHandler().getDescription(media));
                mb.setUuid(media.getUUID());
                try {
                    mb.setWritable(media.getParent().isGranted(11L));
                    mb.setCanPublish(!MediaEl.module().isSingleinstance() && mb.isWritable() && ActivationManagerFactory.getActivationManager().hasAnyActiveSubscriber());
                    mb.getUsedInWebPages().addAll(MediaConfigurationManager.getInstance().getUsedInWebPages(media.getUUID()));
                }
                catch (RepositoryException ex) {
                    MediaFolderViewPage.this.log.error("Exception caught", (Throwable)ex);
                }
                mb.setMediaInfo(mtc.getHandler().getMediaInfo(media));
                mb.setExternal(mtc.getHandler().isExternal(media));
                return mb;
            }
        }) : CollectionUtils.EMPTY_COLLECTION;
        return super.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String delete() {
        HierarchyManager hm = MgnlContext.getInstance().getHierarchyManager("media");
        try {
            ExclusiveWrite exclusiveWrite = ExclusiveWrite.getInstance();
            synchronized (exclusiveWrite) {
                hm.delete(this.node);
                hm.save();
            }
        }
        catch (RepositoryException ex) {
            this.log.error("Exception deleting node {} from repository media", (Object)this.node, (Object)ex);
        }
        return this.show();
    }

    public String move() {
        String nodeName = StringUtils.substringAfterLast((String)this.node, (String)"/");
        String destinationNode = this.dest + "/" + nodeName;
        try {
            this.copyMoveNode(this.node, destinationNode, true);
        }
        catch (ExchangeException e) {
            this.log.error("Exception deactivating node", (Throwable)e);
            AlertUtil.setMessage((String)"Problem during deactivation");
        }
        catch (RepositoryException e) {
            this.log.error("Exception moving node", (Throwable)e);
            AlertUtil.setMessage((String)"Problem during moving");
        }
        return this.show();
    }

    public String copy() {
        String nodeName = StringUtils.substringAfterLast((String)this.node, (String)"/");
        String destinationNode = this.dest + "/" + nodeName;
        try {
            this.copyMoveNode(this.node, destinationNode, false);
        }
        catch (ExchangeException e) {
            this.log.error("Exception deactivating node", (Throwable)e);
            AlertUtil.setMessage((String)"Problem during deactivation");
        }
        catch (RepositoryException e) {
            this.log.error("Exception copying node", (Throwable)e);
            AlertUtil.setMessage((String)"Problem during copying");
        }
        return this.show();
    }

    public Content copyMoveNode(String source, String destination, boolean move) throws ExchangeException, RepositoryException {
        Content newContent;
        block8: {
            HierarchyManager hm = MgnlContext.getHierarchyManager((String)"media");
            String goTo = destination;
            if (hm.isExist(destination)) {
                String parentPath = StringUtils.substringBeforeLast((String)destination, (String)"/");
                String label = StringUtils.substringAfterLast((String)destination, (String)"/");
                label = Path.getUniqueLabel((HierarchyManager)hm, (String)parentPath, (String)label);
                goTo = parentPath + "/" + label;
            }
            if (move) {
                if (destination.indexOf(source + "/") == 0) {
                    return null;
                }
                try {
                    hm.moveTo(source, goTo);
                }
                catch (Exception e) {
                    return null;
                }
            } else {
                hm.copyTo(source, goTo);
            }
            newContent = hm.getContent(destination);
            try {
                newContent.updateMetaData();
                newContent.getMetaData().setUnActivated();
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) break block8;
                this.log.debug("Exception caught: " + e.getMessage(), (Throwable)e);
            }
        }
        newContent.save();
        return newContent;
    }

    public String activate() {
        Command cmd = CommandsManager.getInstance().getCommand("default", "activateMedia");
        ActivationCommand actCmd = (ActivationCommand)cmd;
        StringBuffer sb = new StringBuffer();
        sb.append(MediaConfigurationManager.MEDIA.getSystemName());
        sb.append(",");
        sb.append(ItemType.CONTENTNODE.getSystemName());
        actCmd.setItemTypes(sb.toString());
        info.magnolia.context.Context context = MgnlContext.getInstance();
        context.put((Object)"repository", (Object)"media");
        context.put((Object)"path", (Object)this.node);
        context.put((Object)"recursive", (Object)false);
        try {
            cmd.execute((Context)context);
        }
        catch (Exception e) {
            AlertUtil.setMessage((String)("Activation failed: " + e.getMessage()));
            this.log.error("Exception activating media", (Throwable)e);
        }
        return this.show();
    }

    public String deactivate() {
        Command cmd = CommandsManager.getInstance().getCommand("default", "deactivate");
        info.magnolia.context.Context context = MgnlContext.getInstance();
        context.put((Object)"repository", (Object)"media");
        context.put((Object)"path", (Object)this.node);
        try {
            cmd.execute((Context)context);
        }
        catch (Exception e) {
            AlertUtil.setMessage((String)("Deactivation failed: " + e.getMessage()));
            this.log.error("Exception activating media", (Throwable)e);
        }
        return this.show();
    }

    public String download() {
        Content media;
        HierarchyManager hm = MgnlContext.getHierarchyManager((String)"media");
        try {
            media = hm.getContent(this.path);
        }
        catch (RepositoryException e) {
            this.log.error("Error downloading media " + this.path, (Throwable)e);
            return null;
        }
        MediaTypeConfiguration mtc = MediaConfigurationManager.getInstance().getMediaTypeConfigurationFromMedia(media);
        String url = mtc.getHandler().getUrl(media);
        String filename = mtc.getHandler().getFullFilename(media);
        this.response.addHeader("Content-Disposition", "attachment; filename=" + filename);
        try {
            this.request.getRequestDispatcher(url).forward((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (ServletException e) {
            this.log.error("Error downloading media " + this.path, (Throwable)e);
        }
        catch (IOException e) {
            this.log.error("Error downloading media " + this.path, (Throwable)e);
        }
        return null;
    }

    public String getPath() {
        return this.path;
    }

    public Collection<MediaBean> getMedias() {
        return this.medias;
    }

    public void setMedias(Collection<MediaBean> medias) {
        this.medias = medias;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Collection<MediaTypeConfiguration> getTypes() {
        return this.types;
    }

    public void setTypes(Collection<MediaTypeConfiguration> types) {
        this.types = types;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public void setWritable(boolean writable) {
        this.writable = writable;
    }

    public boolean isCanPublish() {
        return this.canPublish;
    }

    public void setCanPublish(boolean canPublish) {
        this.canPublish = canPublish;
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public String getDest() {
        return this.dest;
    }

    public void setDest(String dest) {
        this.dest = dest;
    }

    public boolean isSelectMedia() {
        return this.selectMedia;
    }

    public void setSelectMedia(boolean selectMedia) {
        this.selectMedia = selectMedia;
    }

    public String getActMediaHandle() {
        return this.actMediaHandle;
    }

    public void setActMediaHandle(String actMediaHandle) {
        this.actMediaHandle = actMediaHandle;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public Map<String, Integer> getNumberOfMedia() {
        return this.numberOfMedia;
    }

    public void setNumberOfMedia(Map<String, Integer> numberOfMedia) {
        this.numberOfMedia = numberOfMedia;
    }

    public boolean isDevelop() {
        return this.develop;
    }

    public void setDevelop(boolean develop) {
        this.develop = develop;
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public boolean isSingleInstance() {
        return MediaEl.module().isSingleinstance();
    }

    public String getBgSelector() {
        for (Cookie cookie : this.request.getCookies()) {
            if (!"bgselector".equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return "white";
    }

    public String getMessage(String key, String param) {
        return this.getMsgs().get(key, (Object[])new String[]{param});
    }
}

