/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.dialog;

import info.magnolia.cms.beans.runtime.Document;
import info.magnolia.cms.beans.runtime.MultipartForm;
import info.magnolia.cms.gui.control.File;
import info.magnolia.cms.gui.dialog.DialogFile;
import info.magnolia.cms.gui.misc.Spacer;
import info.magnolia.cms.i18n.Messages;
import info.magnolia.cms.i18n.MessagesManager;
import info.magnolia.cms.i18n.MessagesUtil;
import java.io.IOException;
import java.io.Writer;
import net.sourceforge.openutils.mgnlmedia.media.tags.el.MediaEl;
import org.apache.commons.lang.StringUtils;

public class DialogFileNoPreview
extends DialogFile {
    private final String i18nBasename = "net.sourceforge.openutils.mgnlmedia.media.lang.messages";
    private Messages messages;

    public void initImageExtensions() {
    }

    public void drawHtml(Writer out) throws IOException {
        this.getImageExtensions().clear();
        this.setConfig("preview", false);
        super.drawHtml(out);
    }

    public void drawHtmlPre(Writer out) throws IOException {
        super.drawHtmlPre(out);
        String extensions = this.getConfigValue("extensions");
        if (StringUtils.isNotBlank((String)extensions)) {
            StringBuffer sb = new StringBuffer();
            sb.append("<span class=\"mgnlDialogDescription\">").append(this.getMessage("dialog.filenopreview.extensions")).append(" ").append(extensions).append("</span>").append(Spacer.getHtml((int)0, (int)0));
            out.write(sb.toString());
        }
    }

    public boolean validate() {
        String extensions;
        Document doc;
        MultipartForm form;
        boolean valid = super.validate();
        if (valid && (form = (MultipartForm)this.getRequest().getAttribute("multipartform")) != null && (doc = form.getDocument(this.getName())) != null && StringUtils.isNotBlank((String)(extensions = this.getConfigValue("extensions")))) {
            String[] allowedExtensions;
            for (String allowedExtension : allowedExtensions = StringUtils.split((String)extensions, (char)',')) {
                if (!StringUtils.trimToEmpty((String)allowedExtension).equalsIgnoreCase(doc.getExtension())) continue;
                return true;
            }
            this.setValidationMessage(this.getMessage("dialog.filenopreview.error.extension"));
            return false;
        }
        return valid;
    }

    protected Messages getMessages() {
        if (this.messages == null) {
            this.messages = this.getParent() == null ? MessagesManager.getMessages() : super.getMessages();
            String basename = this.getConfigValue("i18nBasename", "net.sourceforge.openutils.mgnlmedia.media.lang.messages");
            if (StringUtils.isNotEmpty((String)basename)) {
                this.messages = MessagesUtil.chain((String)basename, (Messages)this.messages);
            }
        }
        return this.messages;
    }

    protected void writeInnerHtml(Writer out, boolean showImage, File control, StringBuffer htmlControlFileName, String link) throws IOException {
        out.write(htmlControlFileName.toString());
        if (!showImage) {
            String iconPath = MediaEl.urlres(control.getWebsiteNode(), "16x16");
            out.write(Spacer.getHtml((int)0, (int)0));
            out.write("<a href=");
            out.write(link);
            out.write(" target=\"_blank\" style=\"color: #000; text-decoration: none; padding-left: 20px; background-image: url(");
            out.write(this.getRequest().getContextPath() + iconPath);
            out.write("); background-position: left; background-repeat: no-repeat\">");
            out.write(control.getFileName() + "." + control.getExtension() + "</a>");
        }
    }

    protected String getFileURI(File control) {
        return "/mediaObject" + control.getHandle();
    }
}

