/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.configuration;

import info.magnolia.cms.beans.config.ObservedManager;
import info.magnolia.cms.beans.config.URI2RepositoryManager;
import info.magnolia.cms.beans.config.URI2RepositoryMapping;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.core.search.Query;
import info.magnolia.cms.core.search.QueryManager;
import info.magnolia.cms.core.search.QueryResult;
import info.magnolia.cms.util.ContentUtil;
import info.magnolia.cms.util.FactoryUtil;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.content2bean.Content2BeanUtil;
import info.magnolia.context.MgnlContext;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaTypeConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaConfigurationManager
extends ObservedManager {
    private static final String MGNL_MEDIA_TYPE = "mgnl:media";
    private static final String MGNL_RESOLUTION_TYPE = "mgnl:resolutions";
    public static final ItemType FOLDER = ItemType.CONTENT;
    public static final ItemType MEDIA = new ItemType("mgnl:media");
    public static final ItemType RESOLUTIONS = new ItemType("mgnl:resolutions");
    private Logger log = LoggerFactory.getLogger(MediaConfigurationManager.class);
    private Map<String, MediaTypeConfiguration> types = new LinkedHashMap<String, MediaTypeConfiguration>();

    protected void onClear() {
        this.types.clear();
    }

    protected void onRegister(Content node) {
        for (Content typeNode : ContentUtil.getAllChildren((Content)node)) {
            if (!NodeDataUtil.getBoolean((Content)typeNode, (String)"enabled", (boolean)true)) continue;
            try {
                MediaTypeConfiguration conf = (MediaTypeConfiguration)Content2BeanUtil.toBean((Content)typeNode, (boolean)true, MediaTypeConfiguration.class);
                if (conf.getHandler() == null) {
                    this.log.error("Missing handler for media type {}", (Object)typeNode.getName());
                    continue;
                }
                conf.getHandler().init(typeNode);
                this.types.put(typeNode.getName(), conf);
            }
            catch (Throwable e) {
                this.log.error("Error getting media type configuration for {}", (Object)typeNode.getHandle(), (Object)e);
            }
        }
    }

    public static MediaConfigurationManager getInstance() {
        return (MediaConfigurationManager)((Object)FactoryUtil.getSingleton(MediaConfigurationManager.class));
    }

    public static MediaTypeConfiguration getMediaHandlerFromExtension(String extension) {
        for (Map.Entry<String, MediaTypeConfiguration> entry : MediaConfigurationManager.getInstance().getTypes().entrySet()) {
            if (!entry.getValue().getExtensionsList().contains(extension.toLowerCase())) continue;
            return entry.getValue();
        }
        return null;
    }

    public Map<String, MediaTypeConfiguration> getTypes() {
        return this.types;
    }

    public Collection<Content> getMediaNodes(Content folder) {
        return this.getMediaNodes(folder, null, "modificationdate");
    }

    public List<String> getUsedInWebPages(String uuid) throws InvalidQueryException, RepositoryException {
        ArrayList<String> handles = new ArrayList<String>();
        QueryManager qm = MgnlContext.getQueryManager((String)"website");
        Query q = qm.createQuery("select * from nt:base where contains(., '" + uuid + "')", "sql");
        QueryResult qr = q.execute();
        Collection nodes = qr.getContent(ItemType.CONTENT.getSystemName());
        if (nodes != null) {
            for (Content c : nodes) {
                if (handles.contains(c.getHandle())) continue;
                handles.add(c.getHandle());
            }
        }
        return handles;
    }

    public Collection<Content> getMediaNodes(final Content folder, final String type, final String sorting) {
        List medias = (List)folder.getChildren(new Content.ContentFilter(){

            public boolean accept(Content content) {
                try {
                    return content.getItemType().equals((Object)MEDIA) && NodeDataUtil.getString((Content)content, (String)"type").equals(type);
                }
                catch (RepositoryException e) {
                    MediaConfigurationManager.this.log.error("Error getting item type on node {} module media", (Object)folder.getHandle(), (Object)e);
                    return false;
                }
            }
        });
        final MediaConfigurationManager mcm = this;
        Collections.sort(medias, new Comparator<Content>(){
            private Map<String, Integer> mapNpages = new HashMap<String, Integer>();

            @Override
            public int compare(Content o1, Content o2) {
                if (sorting.equals("filename")) {
                    return o1.getName().compareTo(o2.getName());
                }
                if (sorting.equals("modificationdate")) {
                    Calendar o1c = o1.getMetaData().getModificationDate() == null ? o1.getMetaData().getCreationDate() : o1.getMetaData().getModificationDate();
                    Calendar o2c = o2.getMetaData().getModificationDate() == null ? o2.getMetaData().getCreationDate() : o2.getMetaData().getModificationDate();
                    return o1c.compareTo(o2c);
                }
                if (sorting.equals("usage")) {
                    Integer nPages1 = this.mapNpages.get(o1.getHandle());
                    Integer nPages2 = this.mapNpages.get(o1.getHandle());
                    if (nPages1 == null) {
                        try {
                            nPages1 = mcm.getUsedInWebPages(o1.getUUID()).size();
                        }
                        catch (InvalidQueryException e) {
                            nPages1 = 0;
                            MediaConfigurationManager.this.log.error("Exception getting web pages for media {}", (Object)o1.getHandle(), (Object)e);
                        }
                        catch (RepositoryException e) {
                            nPages1 = 0;
                            MediaConfigurationManager.this.log.error("Exception getting web pages for media {}", (Object)o1.getHandle(), (Object)e);
                        }
                        this.mapNpages.put(o1.getHandle(), nPages1);
                    }
                    if (nPages2 == null) {
                        try {
                            nPages2 = mcm.getUsedInWebPages(o2.getUUID()).size();
                        }
                        catch (InvalidQueryException e) {
                            nPages2 = 0;
                            MediaConfigurationManager.this.log.error("Exception getting web pages for media {}", (Object)o2.getHandle(), (Object)e);
                        }
                        catch (RepositoryException e) {
                            nPages2 = 0;
                            MediaConfigurationManager.this.log.error("Exception getting web pages for media {}", (Object)o2.getHandle(), (Object)e);
                        }
                        this.mapNpages.put(o2.getHandle(), nPages2);
                    }
                    return nPages1.compareTo(nPages2);
                }
                try {
                    return o1.getIndex() >= o2.getIndex() ? 1 : -1;
                }
                catch (RepositoryException e) {
                    return 0;
                }
            }
        });
        return medias;
    }

    public Collection<Content> search(String text, String type) throws RepositoryException {
        return this.find(null, type, text, true);
    }

    public Collection<Content> find(String path, String type, String search, boolean recursive) throws RepositoryException {
        QueryManager qm = MgnlContext.getQueryManager((String)"media");
        StringBuffer sbQuery = new StringBuffer("/jcr:root/");
        if (StringUtils.isNotEmpty((String)(path = StringUtils.removeEnd((String)StringUtils.removeStart((String)StringUtils.trimToEmpty((String)path), (String)"/"), (String)"/")))) {
            sbQuery.append(ISO9075.encodePath((String)path)).append('/');
        }
        if (recursive) {
            sbQuery.append('/');
        }
        sbQuery.append("element(*," + MEDIA.getSystemName() + ")");
        ArrayList<String> clauses = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)search)) {
            clauses.add("jcr:contains(.,'" + StringUtils.replace((String)search, (String)"'", (String)"''") + "')");
        }
        if (StringUtils.isNotBlank((String)type)) {
            clauses.add("@type='" + type + "'");
        }
        if (!clauses.isEmpty()) {
            sbQuery.append('[').append(StringUtils.join(clauses, (String)" and ")).append(']');
        }
        if (StringUtils.isNotBlank((String)search)) {
            sbQuery.append(" order by @jcr:score descending");
        }
        Query q = qm.createQuery(new String(sbQuery), "xpath");
        QueryResult qr = q.execute();
        return qr.getContent(MGNL_MEDIA_TYPE);
    }

    public MediaTypeConfiguration getMediaTypeConfigurationFromMedia(Content media) {
        try {
            if (!media.getItemType().equals((Object)MEDIA)) {
                return null;
            }
        }
        catch (RepositoryException e) {
            this.log.error("Error getting item type on node {} module media", (Object)media.getHandle(), (Object)e);
            return null;
        }
        return this.types.get(NodeDataUtil.getString((Content)media, (String)"type"));
    }

    public String getURIMappingPrefix() {
        for (URI2RepositoryMapping mapping : URI2RepositoryManager.getInstance().getMappings()) {
            if (!mapping.getRepository().equals("media")) continue;
            return mapping.getURIPrefix();
        }
        return "";
    }
}

