/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.configuration;

import info.magnolia.cms.beans.config.ObservedManager;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.util.ContentUtil;
import info.magnolia.cms.util.FactoryUtil;
import info.magnolia.cms.util.NodeDataUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import net.sourceforge.openutils.mgnlmedia.media.processors.ImagePostProcessor;
import net.sourceforge.openutils.mgnlmedia.media.processors.ImageResolutionProcessor;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageProcessorsManager
extends ObservedManager {
    private static final String IMAGE_RESOLUTION_PROCESSORS_NAME = "image-resolution";
    private static final String IMAGE_POST_PROCESSORS_NAME = "image-post";
    private Map<String, ImageResolutionProcessor> imageResProcs = new HashMap<String, ImageResolutionProcessor>();
    private Map<String, ImagePostProcessor> imagePostProcs = new HashMap<String, ImagePostProcessor>();

    public static ImageProcessorsManager getInstance() {
        return (ImageProcessorsManager)((Object)FactoryUtil.getSingleton(ImageProcessorsManager.class));
    }

    protected void onClear() {
        this.imageResProcs.clear();
        this.imagePostProcs.clear();
    }

    protected void onRegister(Content parentNode) {
        for (Content processorsNode : ContentUtil.getAllChildren((Content)parentNode)) {
            for (Content node : ContentUtil.getAllChildren((Content)processorsNode)) {
                try {
                    if (IMAGE_POST_PROCESSORS_NAME.equals(processorsNode.getName())) {
                        String classNameHandler = NodeDataUtil.getString((Content)node, (String)"class");
                        Class<?> classHandler = Class.forName(classNameHandler);
                        if (!ImagePostProcessor.class.isAssignableFrom(classHandler)) {
                            this.log.error("Error getting post processor for {}: class {} not implements ImagePostProcessor", (Object)node.getHandle(), classHandler);
                            continue;
                        }
                        ImagePostProcessor imagePostProcessor = (ImagePostProcessor)classHandler.newInstance();
                        this.imagePostProcs.put(node.getName(), imagePostProcessor);
                    }
                    if (!IMAGE_RESOLUTION_PROCESSORS_NAME.equals(processorsNode.getName())) continue;
                    String controlChar = node.getName();
                    String classNameHandler = NodeDataUtil.getString((Content)node, (String)"class");
                    Class<?> classHandler = Class.forName(classNameHandler);
                    if (!ImageResolutionProcessor.class.isAssignableFrom(classHandler)) {
                        this.log.error("Error getting resolution processor for {}: class {} not implements ImageResolutionProcessor", (Object)node.getHandle(), classHandler);
                        continue;
                    }
                    ImageResolutionProcessor imageResolutionProcessor = (ImageResolutionProcessor)classHandler.newInstance();
                    if (!controlChar.equals("default")) {
                        controlChar = controlChar.substring(0, 1);
                    }
                    this.imageResProcs.put(controlChar, imageResolutionProcessor);
                    try {
                        String[] aliases;
                        if (!node.hasNodeData("aliases")) continue;
                        for (String alias : aliases = StringUtils.split((String)NodeDataUtil.getString((Content)node, (String)"aliases"), (String)",")) {
                            this.imageResProcs.put(alias, imageResolutionProcessor);
                        }
                    }
                    catch (RepositoryException ex) {
                    }
                }
                catch (InstantiationException ex) {
                    this.log.error("Error getting media type configuration for {}", (Object)node.getHandle(), (Object)ex);
                }
                catch (IllegalAccessException ex) {
                    this.log.error("Error getting media type configuration for {}", (Object)node.getHandle(), (Object)ex);
                }
                catch (ClassNotFoundException ex) {
                    this.log.error("Error getting media type configuration for {}", (Object)node.getHandle(), (Object)ex);
                }
                catch (RuntimeException ex) {
                    this.log.error("Error getting media type configuration for {}", (Object)node.getHandle(), (Object)ex);
                }
            }
        }
    }

    public ImageResolutionProcessor getImageResolutionProcessor(char controlChar) {
        return this.imageResProcs.get(String.valueOf(controlChar));
    }

    public boolean isValidControlChar(char controlChar) {
        return this.imageResProcs.keySet().contains(String.valueOf(controlChar));
    }

    public ImageResolutionProcessor getDefaultImageResolutionProcessor() {
        return this.imageResProcs.get("default");
    }

    public ImagePostProcessor getImagePostProcessor(String name) {
        return this.imagePostProcs.get(name);
    }

    public Collection<ImagePostProcessor> getImagePostProcessorsList() {
        return this.imagePostProcs.values();
    }

    public Map<String, ImagePostProcessor> getImagePostProcessorsMap() {
        return this.imagePostProcs;
    }
}

