[#if !alreadyrendered]
  <script type="text/javascript" src="${request.contextPath}/.resources/ext/ext-base.js"></script>

  [#if debug]
  <script type="text/javascript" src="${request.contextPath}/.resources/ext/ext-all-debug.js"></script>
  [#else]
  <script type="text/javascript" src="${request.contextPath}/.resources/ext/ext-all.js"></script>
  [/#if]
  <script type="text/javascript" src="${request.contextPath}/.resources/controls/js/LinkField.js"></script>
  <script type="text/javascript" src="${request.contextPath}/.resources/controls/js/CheckColumn.js"></script>
  <script type="text/javascript" src="${request.contextPath}/.resources/controls/js/PipeComboBox.js"></script>
  <script type="text/javascript" src="${request.contextPath}/.resources/controls/js/MediaField.js"></script>
  <script type="text/javascript" src="${request.contextPath}/.resources/controls/js/FckEditorField.js"></script>
  <script type="text/javascript" src="${request.contextPath}/.resources/controls/js/FileField.js"></script>
  <script type="text/javascript" src="${request.contextPath}/.resources/controls/js/ColorField.js"></script>
  <script type="text/javascript">
    // <![CDATA[
    function gridMoveRow(grid, delta) {
      if (grid.selModel.selection) {
        var dat = grid.store.data, r1, r2, j1 = grid.selModel.selection.cell[0], j2 = j1 + delta, k, K = grid.colModel.getColumnCount(), field, e1, e2;
        if (j2 >= 0 && j2 < dat.length) {
          r1 = grid.store.getAt(j1);
          r2 = grid.store.getAt(j2);
          for (k = 0; k < K; k++) {
            field = grid.colModel.getDataIndex(k);
            e1 = {
              grid: grid,
              record: r1,
              field: field,
              originalValue: r1.data[field],
              value: r2.data[field],
              row: j1,
              column: k,
              cancel: false
            };
            e2 = {
              grid: grid,
              record: r2,
              field: field,
              originalValue: r2.data[field],
              value: r1.data[field],
              row: j2,
              column: k,
              cancel: false
            };
            if(grid.fireEvent("validateedit", e1) !== false && !e1.cancel && grid.fireEvent("validateedit", e2) !== false && !e2.cancel){
              r1.set(field, e1.value);
              delete e1.cancel;
              grid.fireEvent("afteredit", e1);

              r2.set(field, e2.value);
              delete e2.cancel;
              grid.fireEvent("afteredit", e2);

              grid.selModel.select(j2, grid.selModel.selection.cell[1]);
            }
          }
        }
      }
    }
    // ]]>
  </script>

  <link rel="stylesheet" type="text/css" href="${request.contextPath}/.resources/ext/css/ext-all.css" />
  <link rel="stylesheet" type="text/css" href="${request.contextPath}/.resources/controls/css/grid.css" />
  <!--[if IE 6]>
    <link rel="stylesheet" type="text/css" href="${request.contextPath}/.resources/controls/css/grid-ie6fix.css" />
  <![endif]-->
[/#if]

[#assign key = uuid?replace("-", "")]

<input type="hidden" id="${name}" name="${name}" value="${gridValue?html}"/>

<div id="grid-container-${name}">
   <div id="grid-${name}"></div>
</div>

[#list configuration.columns?values as colmap]
  [#if (colmap.type?? && colmap.type = 'combo')]
    <select id="combo-${name}" name="combo-${name}" style="display: none;">
    [#list colmap.options?values as option]
      <option value="${option.value}">${option.label}</option>
    [/#list]
    </select>
  [/#if]
[/#list]

<script type="text/javascript">
    // <![CDATA[

function loadTable${key}(action) {
  var numOfRows= ${configuration.rows!10};

  var hidden = document.getElementById('${name}');
  var rows = hidden.value.split(/\r?\n/);

  var i, myData = [];
  for (i = 0; i < numOfRows; i++) {
    myData.push(((action != 'delete' && i < rows.length) ? rows[i] : '').split('\t').concat([ undefined, undefined ]).slice(0, ${configuration.columns?size}));
  }

  var dataStore = new Ext.data.SimpleStore({
    fields: [ [#list configuration.columns?values as colmap]'${colmap_index}'[#if colmap_has_next],[/#if][/#list] ]
  });
  dataStore.loadData(myData);

  // shorthand alias
  var fm = Ext.form, Ed = Ext.grid.GridEditor;

  var checkColumns = [];
  [#list configuration.columns?values as colmap]
    [#if (colmap.type?? && colmap.type = 'checkbox')]
      checkColumns.push(new Ext.grid.CheckColumn({
        header: '${msgs.getWithDefault(colmap.header?js_string, colmap.header?js_string)}',
        dataIndex: '${colmap_index}',
        width: 40
      }));
    [/#if]
  [/#list]

  var checkIndex = 0;
  var colModel = new Ext.grid.ColumnModel([
    [#list configuration.columns?values as colmap]
      [#if (colmap.type?? && colmap.type = 'checkbox')]
        checkColumns[checkIndex++]
      [#else]
        {
          header: '${msgs.getWithDefault(colmap.header?js_string, colmap.header?js_string)}',
          dataIndex: '${colmap_index}',
          sortable: false,
        [#if (colmap.type?? && (colmap.type = 'link' || colmap.type = 'uuidLink'))]
          editor: new Ed(new LinkField({
            [#if (colmap.repository??)]repository: '${colmap.repository}',[/#if]
            [#if (colmap.extension??)]extension: '${colmap.extension}',[/#if]
            dummy: undefined 
          }))
        [#elseif (colmap.type?? && colmap.type = 'date')]
          renderer: function(value) {
            return value && Ext.isDate(value) ? value.format('Y-m-d') : value;
          },
          editor: new Ed(new fm.DateField({
            format: 'Y-m-d'
          }))
        [#elseif (colmap.type?? && colmap.type = 'combo')]
          editor: new Ed(new [#if (colmap.pipe?? && colmap.pipe = 'true')]PipeComboBox[#else]fm.ComboBox[/#if]({
             typeAhead: true,
             triggerAction: 'all',
             transform: 'combo-${name}',
             lazyRender: true,
             listClass: 'x-combo-list-small'
          }))
        [#elseif (colmap.type?? && colmap.type = 'media')]
          editor: new Ed(new MediaField({
          })),
          renderer : function(v, p, record){
            return v ? '<img border="0" alt="" src="${request.contextPath}/mediaObject' + v + '/resolutions/thumbnail/data.jpg" [#if (colmap.previewWidth??)]width="${colmap.previewWidth}"[/#if] [#if (colmap.previewHeight??)]height="${colmap.previewHeight}"[/#if]/>' : v;
          }
        [#elseif (colmap.type?? && colmap.type = 'fckedit')]
          editor: new Ed(new FckEditorField({
          }))
        [#elseif (colmap.type?? && colmap.type = 'file')]
          editor: new Ed(new FileField({
          })),
          renderer : function(v, p, record){
            return v ? v.replace(/^.*\//, '') : v;
          }
        [#elseif (colmap.type?? && colmap.type = 'color')]
          editor: new Ed(new Ext.ux.ColorField({
          })),
          renderer : function(v, p, record){
            return v ? '<em style="display: block; float: left; border: 1px solid #ACA899;"><span style="display: block; width: 10px; height: 10px; line-height: 10px; background-color: ' + v + ';"></span></em>' : '';
          }
        [#else]
          editor: new Ed(new fm.TextField({
            allowBlank: true
          }))
        [/#if]
        }
      [/#if][#if colmap_has_next],[/#if]
    [/#list]
  ]);
  colModel.defaultSortable = true;

  var grid = new Ext.grid.EditorGridPanel({
    store: dataStore,
    cm: colModel,
    selModel: new Ext.grid.CellSelectionModel(),
    autoSizeColumns: true,
    enableColLock: false,
    plugins: checkColumns,
    clicksToEdit: 1,
    renderTo: 'grid-${name}',
    tbar: [{
      text: 'Clear all',
      tooltip: 'Clear all',
      icon: '${request.contextPath}/.resources/controls/img/icon-delete.png',
      iconCls: 'button-delete',
      handler: function() {
        var dat = grid.store.data, j, r, k, K = grid.colModel.getColumnCount(), field, e;
        for (j = 0; j < dat.length; j++) {
          r = grid.store.getAt(j);
          for (k = 0; k < K; k++) {
            field = grid.colModel.getDataIndex(k);
            e = {
              grid: grid,
              record: r,
              field: field,
              originalValue: r.data[field],
              value: '',
              row: j,
              column: k,
              cancel: false
            };
            if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
              r.set(field, e.value);
              delete e.cancel;
              grid.fireEvent("afteredit", e);
            }
          }
        }
      }
    }, {
      text: 'Paste from spreadsheet',
      tooltip: 'Paste from spreadsheet',
      icon: '${request.contextPath}/.resources/controls/img/icon-paste.png',
      iconCls: 'button-paste',
      handler: function() {
        mgnlOpenWindow('/.resources/controls/clipboard.html?name=${key}', 320, 200);
      }
    }, {
      text: 'Move up',
      tooltip: 'Move up',
      icon: '${request.contextPath}/.resources/controls/img/icon-move-up.png',
      iconCls: 'button-move-up',
      handler: function() {
        gridMoveRow(grid, -1);
      }
    }, {
      text: 'Move down',
      tooltip: 'Move down',
      icon: '${request.contextPath}/.resources/controls/img/icon-move-down.png',
      iconCls: 'button-move-down',
      handler: function() {
        gridMoveRow(grid, 1);
      }
    }],
    viewConfig: {
      forceFit: true
    }
  });
  grid.render();
  grid.view.fitColumns();
  grid.view.onHeaderChange();

  grid.on('afteredit', function(grid) {
    var dat = grid.grid.store.data;
    var cm = grid.grid.getColumnModel();

    var fullValue = '', j, row, k, cell;
    for (j = 0; j < dat.length; j++) {
      row = dat.item(j);
      for (k = 0; k < cm.getColumnCount(); k++) {
        cell = row.get(k);
        fullValue += Ext.isDate(cell) ? cell.format('Y-m-d') : cell;
        if ((k+1) < cm.getColumnCount()) {
          fullValue += '\t';
        }
      }
      fullValue += '\n';
    }
   hidden.value = fullValue.replace(/\r/g, '');
  }, this, true);

  if (action == 'delete') {
    document.getElementById(areaName).value = '';
  }

  hidden._grid = grid;
}

function paste${key}(text) {
  var hidden = document.getElementById('${name}');
  var grid = hidden._grid;
  var rows, i, I;
  var cols, j, J;

  var data = [];
  rows = text.split('\n');
  I = rows.length;
  if (I > 0 && rows[I - 1] == '') {
    I--;
    rows.splice(I, 1);
  }
  J = 0;
  for (i = 0; i < I; i++) {
    cols = rows[i].split('\t');
    data.push(cols);
    if (J < cols.length) J = cols.length;
  }
  // padding
  for (i = 0; i < I; i++) {
    cols = data[i];
    for (j = cols.length; j < J; j++) {
      cols.push('');
    }
  }

  var cell0, cell1;
  if (grid.selModel.selection) {
    cell0 = grid.selModel.selection.cell[0];
    cell1 = grid.selModel.selection.cell[1];
  } else {
    cell0 = 0;
    cell1 = 0;
  }
  var row, col;
  var record, field;
  var e;
  for (i = 0; i < I; i++) {
    row = cell0 + i;
    record = grid.store.getAt(row);
    if (record) {
      for (j = 0; j < J; j++) {
        col = cell1 + j;
        if (col < grid.colModel.getColumnCount()) {
          field = grid.colModel.getDataIndex(col);
          e = {
            grid: grid,
            record: record,
            field: field,
            originalValue: record.get(field),
            value: data[i][j],
            row: row,
            column: col
          };
          record.set(field, e.value);
          grid.fireEvent("afteredit", e);
        }
      }
    }
  }
}

Ext.onReady(function(){
 loadTable${key}('load','${name}');
});



// ]]>
</script>

