var MediaFolderView = new Class({

  initialize: function(){
    if (Browser.Engine.name == 'trident' && Browser.Engine.version == 4) this.fixNavWidthIE6();
    else this.fixNavWidth();
	new MediaFolderView.BgSelectors('#navigation a.bg-selector');
    new MediaFolderView.EditMenus('li.media .menuitem');
    new MediaFolderView.InfoTooltips('li.media .image');
  },

  fixNavWidth: function(){
    var nav = $('navigation');
    if (nav) nav.setStyle('min-width', (this.calcTotWidth(nav.getElements('.voice')) + 20) + 'px');
  },

  fixNavWidthIE6: function(){
    var nav = $('navigation');
    if (!nav) return;
    var tabs = nav.getElements('.mediatab');
    $('bgselectorblock').setStyles({float: 'none', position: 'absolute', right: 0, top: 0});
    new Element('div', {styles: {float: 'left', width: (this.calcTotWidth(nav.getElements('.voice')) + 20) + 'px'}})
      .adopt(nav.getElements('.mediatab'))
      .inject(nav);
  },

  calcTotWidth: function(items){
    var w = 0;
    items.each(function(item){
      w += item.getSize().x;
    });
    return w;
  }
});

MediaFolderView.BgSelectors = new Class({

  initialize: function(selectors){
    this.selectors = $$(selectors).addEvent('click', this.handleClick.bindWithEvent(this));
    this.previousValue = document.body.className.match(/bg-(\w+)/)[1];
  },

  handleClick: function(e){
    e.stop();
    var selector = $(e.target);
    var value = selector.className.match(/bg-selector\s+(\w+)(-active)?/)[1];
    if (value == this.previousValue) return;
    if (this.previousValue) $(document.body).removeClass('bg-' + this.previousValue);
    $(document.body).addClass('bg-' + value);
    Cookie.write('bgselector', value, {duration: 30});
    this.selectors.each(function(item){
      if (item == selector) item.addClass(value + '-active');
      else if (this.previousValue) item.removeClass(this.previousValue + '-active');
    }, this);
    this.previousValue = value;
  }

});

MediaFolderView.EditMenus = new Class({

  initialize: function(triggers){
    $$(triggers).addEvent('click', this.handleTriggerClick.bindWithEvent(this));
    this.popup = new Element('div').addClass('menupopup').inject(document.body);
    this.popup.addEvents({
      mouseenter: this.handlePopupEnter.bindWithEvent(this),
      mousemove: this.handlePopupMove.bindWithEvent(this),
      mouseleave: this.handlePopupLeave.bindWithEvent(this)
    });
  },

  handleTriggerClick: function(e){
    this.timer = $clear(this.timer);
    var menuitem = $(e.target);
    var menu = menuitem.getNext();
    if (menu != this.menu){
      this.hide();
      var width = menu.getStyle('width')
      var content = new Element('div', {html: menu.get('html')});
      content.getElements('a span').setStyle('width', (width.toInt() - 30) + 'px')
      var coords = menuitem.getCoordinates();
      this.popup
        .empty()
        .grab(content)
        .setStyles({
          left: coords.left + 'px',
          top: (coords.bottom + 5) + 'px',
          width: width,
          display: 'block'
        });
      this.popup.setStyle('height', content.getSize().y + 'px');
      this.menu = menu;
    }
  },

  handlePopupEnter: function(){
    this.timer = $clear(this.timer);
  },

  handlePopupMove: function(e){
    var t = $(e.target);
    if (!this.popup.hasChild(t)) return;
    if (this.li != null && (this.li == t || this.li.hasChild(t))) return;
    if (this.li) this.li.removeClass('active');
    var tag = t.tagName.toLowerCase();
    var li = (tag == 'li' ? t : t.getParent('li'));
    this.li = li;
    if (!li) return;
    li.addClass('active');
    if (Browser.Engine.name == 'trident'){
      var span = li.getElement('span');
      span.set('text', span.get('text'));
    }
  },

  handlePopupLeave: function(e){
    if (!this.timer) this.timer = this.hide.delay(250, this);
  },

  hide: function(){
    if (this.menu){
      this.popup.setStyle('display', '');
      delete this.menu;
    }
    if (this.li){
      this.li.removeClass('active');
      delete this.li;
    }
  }

});

MediaFolderView.InfoTooltips = new Class({

  initialize: function(triggers){
    this.hideStarter = function(){
      this.hideTimer = this.hide.delay(250, this);
    }.bind(this);
    this.hideStopper = function(){
      if (this.hideTimer) this.hideTimer = $clear(this.hideTimer);
    }.bind(this);
    $$(triggers).each(function(trigger){
      var tooltip = trigger.tooltip(trigger.getElement('.details').get('html'), {
        width: 170,
        style: 'alert',
        sticky: true,
        mode: 'auto',
        fixedPosition: true,
        offset: {x: -20, y: 100},
        fx: false,
        noClose: true
      });
      trigger.addEvents({
        'mouseleave': this.hideStarter,
        'mouseenter': this.hideStopper,
        'tooltipshow': this.handleShow.bind(this, trigger),
        'tooltiphide': this.handleHide.bind(this, trigger)
      });
      tooltip.tooltip.addEvents({
        'mouseenter': this.hideStopper,
        'mouseleave': this.hideStarter
      });
    }, this);
  },

  handleShow: function(el){
    this.hideStopper();
    if (this.trigger) this.trigger.tooltip_hide();
    this.trigger = el;
  },

  handleHide: function(el){
    if (this.trigger == el) this.trigger = null;
  },

  hide: function(){
    if (!this.trigger) return;
    this.trigger.tooltip_hide();
    this.trigger = null;
  }

});