<jsp:root version="2.0" xmlns:jsp="http://java.sun.com/JSP/Page" xmlns:c="http://java.sun.com/jsp/jstl/core"
  xmlns:cms="cms-taglib" xmlns:cmsfn="http://www.magnolia.info/tlds/cmsfn-taglib.tld" xmlns:cmsu="cms-util-taglib"
  xmlns:fmt="http://java.sun.com/jsp/jstl/fmt" xmlns:fn="http://java.sun.com/jsp/jstl/functions" xmlns:media="http://net.sourceforge.openutils/mgnlMedia"
  xmlns:su="http://openutils.sf.net/openutils-stringutils">
  <jsp:directive.tag pageEncoding="UTF-8" description="Renders the flash-content and the javascript for replacing it" />
  <jsp:directive.attribute name="player" required="true" rtexprvalue="true" type="java.lang.String" description="the swf file of the player (examples: player.swf (default), jwplayer4, jwplayer5, jwplayer5/player.swf, /.resources/media/players/jwplayer5/player.swf)" />
  <jsp:directive.attribute name="width" required="false" rtexprvalue="true" type="java.lang.Integer" description="flash content width" />
  <jsp:directive.attribute name="height" required="false" rtexprvalue="true" type="java.lang.Integer" description="flash content height" />
  <jsp:directive.tag dynamic-attributes="attrs" />
  <!-- end attributes -->


  <c:set var="debug" value="${false}"/><!-- set to true to print out the generated javascript on page -->
  <c:set var="previewId" value="preview-${su:randomAlphanumeric(6)}" />
  <div id="${previewId}" class="preview"><!-- -->
  </div>
  <c:if test="${empty requestScope['mgnlmedia_swfobject_link_drawn']}">
    <script type="text/javascript" src="${pageContext.request.contextPath}/.resources/media/js/swfobject.js"><!-- -->
    </script>
    <c:set var="mgnlmedia_swfobject_link_drawn" scope="request" value="true" />
  </c:if>
  <c:choose>
    <c:when test="${player eq 'jwplayer4'}">
      <c:set var="player" value="player.swf" />
    </c:when>
    <c:when test="${player eq 'jwplayer5'}">
      <c:set var="player" value="jwplayer5/player.swf" />
    </c:when>
  </c:choose>
  <c:set var="playerPath">
    <c:choose>
      <c:when test="${fn:startsWith(player, '/')}">${pageContext.request.contextPath}${player}</c:when>
      <c:otherwise>${pageContext.request.contextPath}/.resources/media/players/${player}</c:otherwise>
    </c:choose>
  </c:set>
  <script type='text/javascript'>
    <![CDATA[
    var swfobject = new SWFObject('${playerPath}','player','${width}','${height}','9','#ffffff');]]>
    <c:forEach var="attr" items="${attrs}">
      <c:if test="${!empty attr.value}">
        <![CDATA[
    swfobject.addParam('${attr.key}','${attr.value}');]]>
      </c:if>
    </c:forEach>
    <![CDATA[
    var version = deconcept.SWFObjectUtil.getPlayerVersion();
    if (!(version["major"] == 0 || version["major"] < 9)) {
      swfobject.write('${previewId}');
    }]]>
  </script>
  <c:if test="${debug}">
    <pre>
    <![CDATA[
    var swfobject = new SWFObject('${playerPath}','player','${width}','${height}','9','#ffffff');]]>
    <c:forEach var="attr" items="${attrs}">
      <c:if test="${!empty attr.value}">
        <![CDATA[
    swfobject.addParam('${attr.key}','${attr.value}');]]>
      </c:if>
    </c:forEach>
    <![CDATA[
    var version = deconcept.SWFObjectUtil.getPlayerVersion();
    if (!(version["major"] == 0 || version["major"] < 9)) {
      swfobject.write('${previewId}');
    }]]>
    </pre>
  </c:if>
  
  
</jsp:root>