/**
 *
 * Magnolia SimpleMedia Module (http://www.openmindlab.com/lab/products/media.html)
 * Copyright (C)2008 - 2010, Openmind S.r.l. http://www.openmindonline.it
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.sourceforge.openutils.mgnlmedia.media.lifecycle;

import info.magnolia.module.ModuleLifecycle;
import info.magnolia.module.ModuleLifecycleContext;
import info.magnolia.module.ModuleRegistry;
import net.sourceforge.openutils.mgnlmedia.media.configuration.ImageProcessorsManager;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * Media module lifecycle manager
 * @author molaschi
 */
public class MediaModule implements ModuleLifecycle
{

    /**
     * Media module name.
     */
    public static final String NAME = "media";

    /**
     * Media repository name.
     */
    public static final String REPO = "media";

    private Logger log = LoggerFactory.getLogger(MediaModule.class);

    private boolean singleinstance;

    private String player = "player.swf";

    private String version;

    /**
     * Constructor
     */
    public MediaModule()
    {
    }

    /**
     * {@inheritDoc}
     */
    public void start(ModuleLifecycleContext ctx)
    {
        log.info("Starting module media");
        ctx.registerModuleObservingComponent("mediatypes", MediaConfigurationManager.getInstance());
        ctx.registerModuleObservingComponent("processors", ImageProcessorsManager.getInstance());
        version = ctx.getCurrentModuleDefinition().getVersion().toString();
    }

    /**
     * {@inheritDoc}
     */
    public void stop(ModuleLifecycleContext ctx)
    {
        log.info("Stopping module media");
    }

    /**
     * @deprecated use singleinstance
     */
    @Deprecated
    public boolean isAutoactivate()
    {
        return singleinstance;
    }

    /**
     * @deprecated use singleinstance
     */
    @Deprecated
    public void setAutoactivate(boolean autoactivate)
    {
        this.singleinstance = autoactivate;
    }

    /**
     * If the singleinstance flag is set, the media module expect that no activation is needed (usually it means the
     * media repository is shared between the author and public instances).
     * @return the value of the singleinstance property
     */
    public boolean isSingleinstance()
    {
        return singleinstance;
    }

    /**
     * If the singleinstance flag is set, the media module expect that no activation is needed (usually it means the
     * media repository is shared between the author and public instances).
     * @param singleinstance true if no activation should be performed
     */
    public void setSingleinstance(boolean singleinstance)
    {
        this.singleinstance = singleinstance;
    }

    public String getPlayer()
    {
        return player;
    }

    public void setPlayer(String player)
    {
        this.player = player;
    }

    /**
     * Returns the version.
     * @return the version
     */
    public String getVersion()
    {
        return version;
    }

}
