/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.playlist.pages;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.i18n.I18nContentSupportFactory;
import info.magnolia.cms.util.ContentUtil;
import info.magnolia.cms.util.NodeDataUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.openutils.mgnlmedia.media.pages.MessagesTemplatedMVCHandler;
import net.sourceforge.openutils.mgnlmedia.media.tags.el.MediaEl;
import net.sourceforge.openutils.mgnlmedia.playlist.PlaylistConstants;
import net.sourceforge.openutils.mgnlmedia.playlist.pages.PlaylistBean;
import net.sourceforge.openutils.mgnlmedia.playlist.pages.PlaylistEntryBean;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaylistView
extends MessagesTemplatedMVCHandler {
    private Logger log = LoggerFactory.getLogger(PlaylistView.class);
    private String path;
    private PlaylistBean playlist;
    private String title;
    private String description;

    public PlaylistView(String name, HttpServletRequest request, HttpServletResponse response) {
        super(name, request, response);
    }

    public void setPath(String path) {
        this.path = path;
    }

    public PlaylistBean getPlaylist() {
        return this.playlist;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String show() {
        if (StringUtils.isNotBlank((String)this.path)) {
            Content node = ContentUtil.getContent((String)"playlists", (String)this.path);
            if (node != null) {
                this.playlist = new PlaylistBean();
                this.playlist.setUuid(node.getUUID());
                this.playlist.setHandle(node.getHandle());
                this.playlist.setTitle(NodeDataUtil.getString((Content)node, (String)"title"));
                this.playlist.setDescription(NodeDataUtil.getString((Content)node, (String)"description"));
                ArrayList<PlaylistEntryBean> entries = new ArrayList<PlaylistEntryBean>();
                Collection children = node.getChildren(PlaylistConstants.PLAYLIST_ENTRY);
                for (Content subNode : children) {
                    String mediaUUID = NodeDataUtil.getString((Content)subNode, (String)"media");
                    Content media = ContentUtil.getContentByUUID((String)"media", (String)mediaUUID);
                    if (media != null) {
                        PlaylistEntryBean entry = new PlaylistEntryBean();
                        entry.setHandle(subNode.getHandle());
                        entry.setMedia(media.getUUID());
                        entry.setThumbnail(MediaEl.thumbnail(media));
                        entry.setType(NodeDataUtil.getString((Content)media, (String)"type"));
                        entry.setTitle(I18nContentSupportFactory.getI18nSupport().getNodeData(media, "title").getString());
                        entry.setDescription(I18nContentSupportFactory.getI18nSupport().getNodeData(media, "description").getString());
                        entry.setTags(I18nContentSupportFactory.getI18nSupport().getNodeData(media, "tags").getString());
                        entries.add(entry);
                        continue;
                    }
                    this.log.warn("Node {} referenced by entry {} of playlist {} does not exist in media repository", new Object[]{mediaUUID, subNode.getName(), this.playlist.getHandle()});
                }
                this.playlist.setEntries(entries);
            } else {
                this.log.warn("Node {} does not exist in playlist repository", (Object)this.path);
            }
        }
        return super.show();
    }

    public String save() {
        Content node = ContentUtil.getContent((String)"playlists", (String)this.path);
        if (node != null) {
            try {
                NodeDataUtil.getOrCreateAndSet((Content)node, (String)"title", (Object)this.title);
                NodeDataUtil.getOrCreateAndSet((Content)node, (String)"description", (Object)this.description);
                if (MediaEl.module().isSingleinstance()) {
                    node.getMetaData().setActivated();
                }
                node.save();
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return null;
    }
}

