/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.playlist.dialog;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.Path;
import info.magnolia.context.MgnlContext;
import info.magnolia.module.admininterface.SaveHandler;
import info.magnolia.module.admininterface.dialogs.ConfiguredDialog;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.openutils.mgnlmedia.media.tags.el.MediaEl;
import net.sourceforge.openutils.mgnlmedia.playlist.PlaylistConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaylistEntryDialogMVC
extends ConfiguredDialog {
    private Logger log = LoggerFactory.getLogger(PlaylistEntryDialogMVC.class);

    public PlaylistEntryDialogMVC(String name, HttpServletRequest request, HttpServletResponse response, Content configNode) {
        super(name, request, response, configNode);
    }

    protected void configureSaveHandler(SaveHandler saveHandler) {
        super.configureSaveHandler(saveHandler);
        saveHandler.setCreationItemType(PlaylistConstants.PLAYLIST_ENTRY);
    }

    protected boolean onPreSave(SaveHandler control) {
        HierarchyManager hm = MgnlContext.getHierarchyManager((String)"playlists");
        Content c = null;
        try {
            c = hm.getContent(control.getPath());
        }
        catch (RepositoryException e) {
            this.log.error("error getting {}", (Object)control.getPath(), (Object)e);
            return false;
        }
        control.setNodeName(Path.getUniqueLabel((Content)c, (String)"entry"));
        return super.onPreSave(control);
    }

    protected boolean onPostSave(SaveHandler control) {
        Content node;
        boolean result = super.onPostSave(control);
        if (result && (node = this.getStorageNode()) != null) {
            try {
                node.updateMetaData();
                node.save();
            }
            catch (RepositoryException e1) {
                // empty catch block
            }
            if (MediaEl.module().isSingleinstance()) {
                try {
                    node.getMetaData().setActivated();
                    node.save();
                }
                catch (RepositoryException e) {
                    this.log.error("Error adding activated status to playlist entry node", (Throwable)e);
                }
            }
        }
        return result;
    }
}

