/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.utils;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.NodeData;
import info.magnolia.cms.util.ExclusiveWrite;
import info.magnolia.context.Context;
import info.magnolia.context.MgnlContext;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.jcr.RepositoryException;
import net.sourceforge.openutils.mgnlmedia.media.configuration.ImageProcessorsManager;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaTypeConfiguration;
import net.sourceforge.openutils.mgnlmedia.media.processors.ImagePostProcessor;
import net.sourceforge.openutils.mgnlmedia.media.utils.BadImageFormatException;
import net.sourceforge.openutils.mgnlmedia.media.utils.JpegUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImageUtils {
    private static Logger log = LoggerFactory.getLogger(ImageUtils.class);
    private static SimpleDateFormat sdf;
    public static String RESOLUTION_PROPERTY;
    private static final String[] extensions;

    private ImageUtils() {
    }

    private static int getType(ColorModel cm) {
        if (cm.getTransparency() == 2) {
            if (cm.isAlphaPremultiplied()) {
                return 7;
            }
            return 6;
        }
        if (cm.getTransparency() == 3) {
            if (cm.isAlphaPremultiplied()) {
                return 3;
            }
            return 2;
        }
        if (cm.getPixelSize() == 8) {
            return 5;
        }
        return 1;
    }

    public static BufferedImage resizeImage(BufferedImage original, int x, int y) {
        return ImageUtils.resizeImage(original, x, y, x, y, null);
    }

    public static BufferedImage resizeImage(BufferedImage original, int x, int y, int canvasX, int canvasY, Color background) {
        BufferedImage resizedImage;
        if (x <= 0) {
            x = 1;
        }
        if (y <= 0) {
            y = 1;
        }
        if (canvasX <= 0) {
            canvasX = 1;
        }
        if (canvasY <= 0) {
            canvasY = 1;
        }
        try {
            resizedImage = new BufferedImage(canvasX, canvasY, ImageUtils.getType(original.getColorModel()));
        }
        catch (NegativeArraySizeException e) {
            throw new RuntimeException("NegativeArraySizeException caught when resizing image to [" + canvasX + ", " + canvasY + "]");
        }
        Graphics2D graphics2D = resizedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (canvasX > x || canvasY > y) {
            graphics2D.clearRect(0, 0, canvasX, canvasY);
            if (background == null && original.getColorModel().getTransparency() == 1) {
                background = Color.WHITE;
            }
            if (background != null) {
                graphics2D.setColor(background);
                if (canvasX > x) {
                    graphics2D.fillRect(0, 0, (canvasX - x) / 2, canvasY);
                    graphics2D.fillRect(canvasX - (canvasX - x) / 2, 0, canvasX, canvasY);
                }
                if (canvasY > y) {
                    graphics2D.fillRect(0, 0, canvasX, (canvasY - y) / 2);
                    graphics2D.fillRect(0, canvasY - (canvasY - y) / 2, canvasX, canvasY);
                }
            }
        }
        if (x > original.getWidth()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.drawImage(original, (canvasX - x) / 2, (canvasY - y) / 2, x, y, background, null);
        } else {
            Image scaledInstance = original.getScaledInstance(x, y, 4);
            graphics2D.drawImage(scaledInstance, (canvasX - x) / 2, (canvasY - y) / 2, x, y, background, null);
        }
        return resizedImage;
    }

    public static BufferedImage cropImage(BufferedImage original, int left, int top, int width, int height) {
        BufferedImage resizedImage = new BufferedImage(width, height, ImageUtils.getType(original.getColorModel()));
        Graphics2D graphics2D = resizedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (width > original.getWidth()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        graphics2D.drawImage(original, 0, 0, width, height, left, top, width + left, height + top, null);
        return resizedImage;
    }

    public static BufferedImage addRoundedCorners(BufferedImage original, Color backgroundColor, int radius) {
        BufferedImage roundedImage;
        int originalImageType = ImageUtils.getType(original.getColorModel());
        int roundedCornersImageType = 6;
        if (originalImageType != 6) {
            if (originalImageType != 7) {
                if (backgroundColor == null) {
                    backgroundColor = Color.WHITE;
                }
            } else {
                roundedCornersImageType = 7;
            }
        }
        try {
            roundedImage = new BufferedImage(original.getWidth(), original.getHeight(), roundedCornersImageType);
        }
        catch (NegativeArraySizeException e) {
            throw new RuntimeException("NegativeArraySizeException caught when adding rounded corners");
        }
        Graphics2D roundedGraphics2D = roundedImage.createGraphics();
        roundedGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        roundedGraphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        roundedGraphics2D.setColor(Color.WHITE);
        roundedGraphics2D.fillRoundRect(0, 0, original.getWidth(), original.getHeight(), radius, radius);
        roundedGraphics2D.setComposite(AlphaComposite.SrcIn);
        roundedGraphics2D.drawImage(original, 0, 0, original.getWidth(), original.getHeight(), null);
        if (backgroundColor != null) {
            BufferedImage destImage;
            try {
                destImage = new BufferedImage(original.getWidth(), original.getHeight(), originalImageType);
            }
            catch (NegativeArraySizeException e) {
                throw new RuntimeException("NegativeArraySizeException caught when resizing image]");
            }
            Graphics2D destImageGraphics2D = destImage.createGraphics();
            destImageGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            destImageGraphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            destImageGraphics2D.setBackground(backgroundColor);
            destImageGraphics2D.clearRect(0, 0, original.getWidth(), original.getHeight());
            destImageGraphics2D.drawImage(roundedImage, 0, 0, original.getWidth(), original.getHeight(), null);
            return destImage;
        }
        return roundedImage;
    }

    public static void saveResolution(BufferedImage image, Content saveTo, String extension, float quality, boolean forceProgressive) throws RepositoryException, IOException {
        ImageUtils.saveResolution(image, saveTo, null, extension, quality, forceProgressive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveResolution(BufferedImage image, Content saveTo, String name, String extension, float quality, boolean forceProgressive) throws RepositoryException, IOException {
        InputStream stream = null;
        try {
            String resolution;
            stream = ImageUtils.getStream(image, extension, quality, forceProgressive);
            if (stream == null) {
                throw new IllegalArgumentException("Stream is null");
            }
            Content resolutions = ImageUtils.getResolutionsNode(saveTo);
            if (resolutions == null) {
                resolutions = saveTo.createContent("resolutions", MediaConfigurationManager.RESOLUTIONS);
                resolutions.getMetaData().setModificationDate();
            }
            if ((resolution = name) == null) {
                resolution = "res-" + image.getWidth() + "x" + image.getHeight();
            }
            String originalRes = resolution;
            resolution = ImageUtils.getResolutionPath(resolution);
            ExclusiveWrite exclusiveWrite = ExclusiveWrite.getInstance();
            synchronized (exclusiveWrite) {
                NodeData nd;
                if (resolutions.hasNodeData(resolution)) {
                    nd = resolutions.getNodeData(resolution);
                    nd.delete();
                }
                nd = resolutions.createNodeData(resolution, 2);
                log.info("setting value to {}", (Object)nd.getHandle());
                nd.setValue(stream);
                String mimetype = "image/" + extension;
                if ("jpg".equals(extension)) {
                    mimetype = "image/jpeg";
                }
                nd.setAttribute(RESOLUTION_PROPERTY, originalRes);
                nd.setAttribute("extension", extension);
                nd.setAttribute("fileName", saveTo.getName());
                nd.setAttribute("jcr:mimeType", mimetype);
                nd.setAttribute("jcr:lastModified", GregorianCalendar.getInstance(TimeZone.getDefault()));
                nd.setAttribute("width", "" + image.getWidth());
                nd.setAttribute("height", "" + image.getHeight());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
    }

    public static String getResolutionPath(String resolution) {
        if (resolution.indexOf(59) > 0) {
            return StringUtils.substringBefore((String)resolution, (String)";") + "-p" + StringUtils.substringAfter((String)resolution, (String)";").hashCode();
        }
        return resolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getStream(BufferedImage image, String extension, float quality, boolean forceProgressive) throws IOException {
        BufferedOutputStream out;
        File tempFile;
        block14: {
            tempFile = File.createTempFile("image-", "." + extension);
            FileOutputStream fos = new FileOutputStream(tempFile);
            out = new BufferedOutputStream(fos);
            try {
                Iterator<ImageWriter> writers = ImageIO.getImageWritersBySuffix(extension);
                if (writers != null && writers.hasNext()) {
                    ImageWriter imageWriter = writers.next();
                    ImageWriteParam params = imageWriter.getDefaultWriteParam();
                    try {
                        String[] compressionTypes = params.getCompressionTypes();
                        if (compressionTypes != null && compressionTypes.length > 0) {
                            params.setCompressionMode(2);
                            params.setCompressionType(compressionTypes[0]);
                            params.setCompressionQuality(quality);
                        } else {
                            params.setCompressionMode(3);
                        }
                        if (forceProgressive) {
                            params.setProgressiveMode(1);
                        } else {
                            params.setProgressiveMode(3);
                        }
                    }
                    catch (UnsupportedOperationException e) {
                        // empty catch block
                    }
                    params.setDestinationType(new ImageTypeSpecifier(image.getColorModel(), image.getSampleModel()));
                    ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(out);
                    imageWriter.setOutput(imageOutputStream);
                    IIOImage iioimage = new IIOImage(image, null, null);
                    try {
                        imageWriter.write(null, iioimage, params);
                        break block14;
                    }
                    catch (NullPointerException e) {
                        image.createGraphics().drawRect(0, 0, 1, 1);
                        imageWriter.write(null, iioimage, params);
                        break block14;
                    }
                    finally {
                        imageOutputStream.close();
                        imageWriter.dispose();
                    }
                }
                ImageIO.write((RenderedImage)image, extension, out);
            }
            catch (IOException ex) {
                log.error("Error writing image to buffer", (Throwable)ex);
                throw ex;
            }
        }
        out.flush();
        IOUtils.closeQuietly((OutputStream)out);
        return new BufferedInputStream(new FileInputStream(tempFile){

            public void close() throws IOException {
                tempFile.delete();
                super.close();
            }
        });
    }

    public static boolean checkOrCreateResolution(Content media, String resolutionTarget) {
        return ImageUtils.checkOrCreateResolution(media, resolutionTarget, "original");
    }

    public static boolean checkOrCreateResolution(final Content media, final String resolutionTarget, String nodeDataName) {
        Content resolutions = ImageUtils.getResolutionsNode(media);
        String resolution = resolutionTarget;
        if (!"thumbnail".equals(resolutionTarget) && !"preview".equals(resolutionTarget)) {
            resolution = "res-" + resolutionTarget;
        }
        try {
            if (resolutions != null && resolutions.hasNodeData(ImageUtils.getResolutionPath(resolution))) {
                return true;
            }
        }
        catch (RepositoryException e1) {
            // empty catch block
        }
        String type = media.getNodeData("type").getString();
        if (StringUtils.equals((String)type, (String)"other")) {
            return false;
        }
        if (nodeDataName == null) {
            MediaTypeConfiguration mtc = MediaConfigurationManager.getInstance().getMediaTypeConfigurationFromMedia(media);
            nodeDataName = mtc == null ? "original" : mtc.getHandler().getPreviewImageNodeDataName();
        }
        try {
            if (!media.hasNodeData(nodeDataName)) {
                return false;
            }
        }
        catch (RepositoryException e2) {
            log.warn(e2.getMessage(), (Throwable)e2);
        }
        final String finalNodeDataName = nodeDataName;
        try {
            ImageUtils.doInSystemContext(new MgnlContext.SystemContextOperation(){

                public void exec() {
                    BufferedImage img;
                    Content node;
                    HierarchyManager hm = MgnlContext.getHierarchyManager((String)"media");
                    String resolution = resolutionTarget;
                    if ("thumbnail".equals(resolution)) {
                        resolution = "l100x100";
                    }
                    if ("preview".equals(resolution)) {
                        resolution = "l450x350";
                    }
                    try {
                        node = hm.getContent(media.getHandle());
                    }
                    catch (RepositoryException e) {
                        throw new RuntimeException(e);
                    }
                    NodeData image = node.getNodeData(finalNodeDataName);
                    if (image.getContentLength() == 0L) {
                        throw new RuntimeException("Invalid image nodedata " + image.getHandle() + ", size " + image.getContentLength());
                    }
                    String extension = image.getAttribute("extension");
                    if (!Arrays.asList(extensions).contains(extension)) {
                        try {
                            image.setAttribute("extension", "jpg");
                        }
                        catch (RepositoryException e) {
                            throw new RuntimeException(e);
                        }
                        extension = "jpg";
                    }
                    BufferedImage original = ImageUtils.createBufferedImage(image);
                    String resolutionName = "res-" + resolution;
                    Map params = ImageUtils.parseParameters(resolution);
                    try {
                        img = ImageUtils.getImageForResolution(original, resolution, params);
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException(e);
                    }
                    try {
                        float quality = 0.8f;
                        if (StringUtils.isNotEmpty((String)((String)params.get("quality")))) {
                            try {
                                quality = NumberUtils.toFloat((String)((String)params.get("quality")));
                                if (quality > 1.0f) {
                                    quality = 1.0f;
                                }
                            }
                            catch (NumberFormatException ex) {
                                log.error("quality parameter must be a float number but was {}", params.get("quality"));
                            }
                        }
                        boolean forceProgressive = false;
                        if (StringUtils.isNotEmpty((String)((String)params.get("progressive")))) {
                            forceProgressive = true;
                        }
                        if ("thumbnail".equals(resolutionTarget) || "preview".equals(resolutionTarget)) {
                            ImageUtils.saveResolution(img, node, resolutionTarget, extension, quality, forceProgressive);
                        } else {
                            ImageUtils.saveResolution(img, node, resolutionName, extension, quality, forceProgressive);
                        }
                    }
                    catch (RepositoryException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    try {
                        hm.save();
                    }
                    catch (RepositoryException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException ex) {
            log.error(ClassUtils.getShortClassName(ex.getClass()) + " checking resolution for " + media.getHandle() + ": " + ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    protected static Content getResolutionsNode(Content media) {
        Content resolutions = null;
        try {
            if (media.hasContent("resolutions")) {
                resolutions = media.getContent("resolutions");
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return resolutions;
    }

    private static Map<String, String> parseParameters(String resolution) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.contains((String)resolution, (String)";")) {
            String[] tokens;
            String parameters = StringUtils.substringAfter((String)resolution, (String)";");
            resolution = StringUtils.substringBefore((String)resolution, (String)";");
            for (String token : tokens = StringUtils.split((String)parameters, (char)',')) {
                if (token.indexOf("=") > 0) {
                    String[] keyvalue = StringUtils.split((String)token, (char)'=');
                    params.put(keyvalue[0], keyvalue[1]);
                    continue;
                }
                params.put(token, "true");
            }
        }
        return params;
    }

    public static BufferedImage getImageForResolution(BufferedImage original, String resolution, Map<String, String> params) {
        if (original == null) {
            throw new IllegalArgumentException("input image is null");
        }
        if (resolution == null || resolution.length() < 1) {
            throw new IllegalArgumentException("Invalid resolution: " + resolution);
        }
        BufferedImage img = null;
        resolution = StringUtils.lowerCase((String)resolution);
        char controlChar = resolution.charAt(0);
        Point size = ImageUtils.parseForSize(resolution);
        if (ImageProcessorsManager.getInstance().isValidControlChar(controlChar)) {
            img = ImageProcessorsManager.getInstance().getImageResolutionProcessor(controlChar).getImageForResolution(original, size.x, size.y, params);
        } else {
            if (controlChar < '0' || controlChar > '9') {
                throw new IllegalArgumentException("Invalid control char: " + controlChar);
            }
            img = ImageProcessorsManager.getInstance().getDefaultImageResolutionProcessor().getImageForResolution(original, size.x, size.y, params);
        }
        for (ImagePostProcessor ipp : ImageProcessorsManager.getInstance().getImagePostProcessorsList()) {
            img = ipp.processImage(img, size.x, size.y, params);
        }
        return img;
    }

    public static String getExtension(Content media, String resolution) {
        try {
            Content resolutions = media.getContent("resolutions");
            NodeData res = resolutions.getNodeData(resolution);
            return res.getAttribute("extension");
        }
        catch (RepositoryException ex) {
            return "jpg";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createBufferedImage(NodeData image) {
        InputStream is = image.getStream();
        try {
            BufferedImage bufferedImage = ImageIO.read(is);
            return bufferedImage;
        }
        catch (IOException e) {
            BufferedImage result = JpegUtils.processNonStandardImage(image);
            if (result == null) {
                throw new BadImageFormatException("Unable to handle " + image.getHandle(), e);
            }
            BufferedImage bufferedImage = result;
            return bufferedImage;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public static Point parseForSize(String res) {
        Point size = new Point();
        String resolution = StringUtils.lowerCase((String)res);
        if (StringUtils.contains((String)resolution, (String)";")) {
            resolution = StringUtils.substringBefore((String)resolution, (String)";");
        }
        if (ImageProcessorsManager.getInstance().isValidControlChar(resolution.charAt(0)) || resolution.charAt(0) < '0' || resolution.charAt(0) > '9') {
            resolution = resolution.substring(1);
        }
        String[] resXY = StringUtils.split((String)resolution, (String)"x");
        size.x = NumberUtils.toInt((String)resXY[0]);
        size.y = NumberUtils.toInt((String)resXY[1]);
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doInSystemContext(MgnlContext.SystemContextOperation op) {
        Context originalCtx = MgnlContext.hasInstance() ? MgnlContext.getInstance() : null;
        try {
            MgnlContext.setInstance((Context)MgnlContext.getSystemContext());
            op.exec();
        }
        finally {
            MgnlContext.setInstance((Context)originalCtx);
        }
    }

    static {
        RESOLUTION_PROPERTY = "resolution";
        extensions = new String[]{"jpg", "gif", "png"};
        sdf = new SimpleDateFormat();
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

