/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.types.impl;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.util.NodeDataUtil;
import java.io.InputStream;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import net.sourceforge.openutils.mgnlmedia.media.types.impl.BaseTypeHandler;
import net.sourceforge.openutils.mgnlmedia.media.utils.ImageUtils;
import org.apache.commons.io.IOUtils;
import org.devlib.schmidt.imageinfo.ImageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageTypeHandler
extends BaseTypeHandler {
    private Logger log = LoggerFactory.getLogger(ImageTypeHandler.class);

    public String getThumbnailUrl(Content media) {
        if (!ImageUtils.checkOrCreateResolution(media, "thumbnail", "original")) {
            return "";
        }
        return MediaConfigurationManager.getInstance().getURIMappingPrefix() + media.getHandle() + "/resolutions/thumbnail/" + media.getName() + "." + ImageUtils.getExtension(media, "thumbnail");
    }

    public String getPreviewUrl(Content media) {
        if (!ImageUtils.checkOrCreateResolution(media, "preview", "original")) {
            return "";
        }
        return MediaConfigurationManager.getInstance().getURIMappingPrefix() + media.getHandle() + "/resolutions/preview/" + media.getName() + "." + ImageUtils.getExtension(media, "preview");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onPostSave(Content media) {
        InputStream stream;
        block4: {
            stream = null;
            try {
                stream = this.getOriginalFileNodeData(media).getStream();
                ImageInfo ii = new ImageInfo();
                ii.setInput(stream);
                if (!ii.check()) break block4;
                NodeDataUtil.getOrCreateAndSet((Content)media, (String)"media_bitdepth", (int)ii.getBitsPerPixel());
                NodeDataUtil.getOrCreateAndSet((Content)media, (String)"media_width", (int)ii.getWidth());
                NodeDataUtil.getOrCreateAndSet((Content)media, (String)"media_height", (int)ii.getHeight());
                media.save();
            }
            catch (Throwable e) {
                try {
                    this.log.warn("Error determining bit depth " + this.getOriginalFileNodeData(media).getHandle() + " " + e.getClass().getName() + " " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(stream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        return super.onPostSave(media);
    }
}

