/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.setup;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.NodeData;
import info.magnolia.cms.core.search.Query;
import info.magnolia.cms.core.search.QueryManager;
import info.magnolia.cms.core.search.QueryResult;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.Task;
import info.magnolia.module.delta.TaskExecutionException;
import java.util.Collection;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveOriginalNodeTask
implements Task {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public String getName() {
        return "file store nodedata name updater";
    }

    public String getDescription() {
        return "update custom nodedata names (where original files are stored) to \"original\"";
    }

    public void execute(InstallContext installContext) throws TaskExecutionException {
        QueryManager mgr = installContext.getHierarchyManager("media").getQueryManager();
        try {
            this.reset(mgr, "image", "image");
            this.reset(mgr, "video", "video");
            this.reset(mgr, "audio", "audio");
        }
        catch (RepositoryException ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private void reset(QueryManager queryManager, String type, String nodedataOldName) throws RepositoryException {
        Query query = queryManager.createQuery("//*[" + nodedataOldName + " and type='" + type + "']", "xpath");
        QueryResult queryResult = query.execute();
        Collection medias = queryResult.getContent(MediaConfigurationManager.MEDIA.getSystemName());
        for (Content media : medias) {
            NodeData nd = media.getNodeData(nodedataOldName);
            if (nd.getValue() != null) {
                NodeData ndNew = media.createNodeData("original", nd.getValue());
                for (String attributeName : (List)nd.getAttributeNames()) {
                    try {
                        ndNew.setAttribute(attributeName, nd.getAttribute(attributeName));
                    }
                    catch (ConstraintViolationException ex) {}
                }
                nd.delete();
            }
            media.save();
        }
    }
}

