/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.processors;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Map;
import net.sourceforge.openutils.mgnlmedia.media.processors.ImagePostProcessor;
import net.sourceforge.openutils.mgnlmedia.media.utils.ImageUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoundedCornersProcessor
implements ImagePostProcessor {
    private Logger log = LoggerFactory.getLogger(RoundedCornersProcessor.class);

    @Override
    public BufferedImage processImage(BufferedImage image, int x, int y, Map<String, String> parameters) {
        String roundCorners = parameters.get("roundcorners");
        if (StringUtils.isNotBlank((String)roundCorners)) {
            int radius = 5;
            if (!"true".equals(roundCorners)) {
                radius = NumberUtils.toInt((String)roundCorners);
            }
            Color backgroundColor = null;
            String hexColor = parameters.get("background");
            if (StringUtils.isNotBlank((String)hexColor)) {
                try {
                    hexColor = "0x" + (hexColor.startsWith("#") ? hexColor.substring(1) : hexColor);
                    backgroundColor = Color.decode(hexColor);
                }
                catch (NumberFormatException e) {
                    this.log.error("Invalid color code: " + hexColor, (Throwable)e);
                }
            }
            return ImageUtils.addRoundedCorners(image, backgroundColor, radius);
        }
        return image;
    }
}

