/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.dialog;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.Path;
import info.magnolia.cms.gui.dialog.Dialog;
import info.magnolia.cms.gui.misc.Sources;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.context.MgnlContext;
import info.magnolia.module.admininterface.SaveHandler;
import info.magnolia.module.admininterface.dialogs.ConfiguredDialog;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import net.sourceforge.openutils.mgnlmedia.media.dialog.LayerDialog;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerDialogMVC
extends ConfiguredDialog {
    private Logger log = LoggerFactory.getLogger(LayerDialogMVC.class);

    public LayerDialogMVC(String name, HttpServletRequest request, HttpServletResponse response, Content configNode) {
        super(name, request, response, configNode);
    }

    protected Dialog createDialog(Content configNode, Content storageNode) throws RepositoryException {
        LayerDialog dialog = new LayerDialog();
        dialog.init(this.request, this.response, storageNode, configNode);
        return dialog;
    }

    public void renderHtml(String view) throws IOException {
        PrintWriter out = this.getResponse().getWriter();
        if ("close".equals(view)) {
            out.println("<html>");
            out.println(new Sources(this.getRequest().getContextPath()).getHtmlJs());
            out.println("<script type=\"text/javascript\">");
            String parentPath = this.path;
            if (parentPath.endsWith(this.nodeName)) {
                parentPath = StringUtils.substringBefore((String)parentPath, (String)("/" + this.nodeName));
            }
            out.println("var path = '" + parentPath + "';");
            out.println("var type = '" + this.getRequest().getParameter("type") + "';");
            out.println("parent.reloadFolder(path, type);");
            out.println("parent.closeLayer();");
            out.println("</script></html>");
        } else if ("show".equals(view)) {
            try {
                this.getDialog().drawHtml((Writer)out);
            }
            catch (IOException e) {
                this.log.error("Exception caught", (Throwable)e);
            }
        }
    }

    protected void configureSaveHandler(SaveHandler saveHandler) {
        super.configureSaveHandler(saveHandler);
        saveHandler.setCreationItemType(MediaConfigurationManager.MEDIA);
    }

    protected boolean onPostSave(SaveHandler handler) {
        super.onPostSave(handler);
        Content node = this.getStorageNode();
        String type = NodeDataUtil.getString((Content)node, (String)"type");
        return MediaConfigurationManager.getInstance().getTypes().get(type).getHandler().onPostSave(node);
    }

    protected boolean onPreSave(SaveHandler control) {
        String type = this.request.getParameter("type");
        if (control.getNodeName().equals("mgnlNew")) {
            HierarchyManager hm = MgnlContext.getHierarchyManager((String)"media");
            Content c = null;
            try {
                c = hm.getContent(control.getPath());
            }
            catch (RepositoryException e) {
                this.log.error("error getting {}", (Object)control.getPath(), (Object)e);
                return false;
            }
            control.setNodeName(Path.getUniqueLabel((Content)c, (String)Path.getValidatedLabel((String)MediaConfigurationManager.getInstance().getTypes().get(type).getHandler().getNewNodeName(this.form, this.request))));
        }
        return super.onPreSave(control);
    }
}

