/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.dialog;

import info.magnolia.cms.beans.runtime.FileProperties;
import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.NodeData;
import info.magnolia.cms.i18n.Messages;
import info.magnolia.cms.i18n.MessagesUtil;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.context.MgnlContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.openutils.mgnlcontrols.dialog.ConfigurableFreemarkerDialog;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaTypeConfiguration;
import net.sourceforge.openutils.mgnlmedia.media.save.MediaCustomSaveHandler;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogSelectMedia
extends ConfigurableFreemarkerDialog {
    private Logger log = LoggerFactory.getLogger(DialogSelectMedia.class);
    private Long width;
    private Long height;

    protected List<Object> readValues() {
        ArrayList<Object> values = new ArrayList<Object>();
        if (this.getStorageNode() != null) {
            try {
                int size = this.getStorageNode().getContent(this.getName()).getNodeDataCollection().size();
                for (int i = 0; i < size; ++i) {
                    NodeData data = this.getStorageNode().getContent(this.getName()).getNodeData("" + i);
                    values.add(data.getString());
                }
            }
            catch (PathNotFoundException e) {
            }
            catch (RepositoryException re) {
                this.log.error("can't set values", (Throwable)re);
            }
        }
        return values;
    }

    public void init(HttpServletRequest request, HttpServletResponse response, Content websiteNode, Content configNode) throws RepositoryException {
        super.init(request, response, websiteNode, configNode);
        if (StringUtils.isEmpty((String)this.getConfigValue("saveHandler"))) {
            this.setConfig("saveHandler", MediaCustomSaveHandler.class.getName());
        }
    }

    protected void addToParameters(Map<String, Object> parameters) {
        Content media = null;
        NodeData nd = null;
        if (this.getStorageNode() != null) {
            nd = this.getStorageNode().getNodeData(this.getName());
        }
        if (nd != null && nd.getType() == 2) {
            parameters.put("binaryfield", true);
        } else if (this.getValue() != null && this.getValue().length() > 0) {
            try {
                HierarchyManager hm = MgnlContext.getHierarchyManager((String)"media");
                media = hm.getContentByUUID(this.getValue());
            }
            catch (RepositoryException ex) {
                this.log.error("Error retriving media {}", (Object)this.value, (Object)ex);
            }
        }
        parameters.put("thumbnailUrl", this.getThumbnailUrl(media, nd));
        parameters.put("msgs", this.getMessages());
        parameters.put("filename", this.getFilename(media, nd));
        if ("true".equals(this.getConfigValue("resizing"))) {
            parameters.put("width", this.getWidth());
            parameters.put("height", this.getHeight());
        }
    }

    protected Messages getMessages() {
        return MessagesUtil.chain((String)"net.sourceforge.openutils.mgnlmedia.media.lang.messages", (Messages)super.getMessages());
    }

    protected String getPath() {
        return "dialog/selectMedia.ftl";
    }

    protected Content getMedia() throws RepositoryException {
        if (this.getValue() != null && this.getValue().length() > 0) {
            HierarchyManager hm = MgnlContext.getHierarchyManager((String)"media");
            return hm.getContentByUUID(this.getValue());
        }
        return null;
    }

    public String getThumbnailUrl(Content media, NodeData nd) {
        if (nd != null && nd.getType() == 2) {
            String url = new FileProperties(this.getStorageNode(), this.getName()).getProperty("path");
            if (StringUtils.isBlank((String)url)) {
                return null;
            }
            return this.getRequest().getContextPath() + url;
        }
        if (media != null) {
            MediaTypeConfiguration mtc = MediaConfigurationManager.getInstance().getMediaTypeConfigurationFromMedia(media);
            return this.getRequest().getContextPath() + mtc.getHandler().getThumbnailUrl(media);
        }
        return null;
    }

    public String getValue() {
        NodeData nd = null;
        if (this.getStorageNode() != null) {
            nd = this.getStorageNode().getNodeData(this.getName());
        }
        if (nd != null && nd.getType() == 2) {
            return new FileProperties(this.getStorageNode(), this.getName()).getProperty("path");
        }
        return super.getValue();
    }

    public String getFilename(Content media, NodeData nd) {
        if (nd != null && nd.getType() == 2) {
            return new FileProperties(this.getStorageNode(), this.getName()).getProperty("name");
        }
        if (media != null) {
            MediaTypeConfiguration mtc = MediaConfigurationManager.getInstance().getMediaTypeConfigurationFromMedia(media);
            String filename = mtc.getHandler().getFilename(media);
            return StringUtils.contains((String)filename, (String)"/") ? StringUtils.substringAfterLast((String)filename, (String)"/") : filename;
        }
        return null;
    }

    public Long getWidth() {
        if (this.width == null && this.getStorageNode() != null) {
            long w = NodeDataUtil.getLong((Content)this.getStorageNode(), (String)(this.getName() + "_width"), (long)-1L);
            this.width = w >= 0L ? Long.valueOf(w) : null;
        }
        return this.width;
    }

    public Long getHeight() {
        if (this.height == null && this.getStorageNode() != null) {
            long h = NodeDataUtil.getLong((Content)this.getStorageNode(), (String)(this.getName() + "_height"), (long)-1L);
            this.height = h >= 0L ? Long.valueOf(h) : null;
        }
        return this.height;
    }
}

