/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.mgnlmedia.media.dialog;

import info.magnolia.cms.beans.config.MIMEMapping;
import info.magnolia.cms.gui.control.File;
import info.magnolia.cms.gui.dialog.DialogFile;
import info.magnolia.cms.gui.misc.Spacer;
import java.io.IOException;
import java.io.Writer;
import net.sourceforge.openutils.mgnlmedia.media.configuration.MediaConfigurationManager;
import org.apache.commons.lang.StringUtils;

public class DialogFileImage
extends DialogFile {
    public void initImageExtensions() {
        this.getImageExtensions().add("jpg");
        this.getImageExtensions().add("jpeg");
        this.getImageExtensions().add("gif");
        this.getImageExtensions().add("png");
        this.getImageExtensions().add("bmp");
    }

    public void drawHtml(Writer out) throws IOException {
        File control = this.getFileControl();
        control.setType(this.getConfigValue("type", "String"));
        control.setSaveInfo(false);
        control.setCssClass("mgnlDialogControlFile");
        control.setCssClassFileName("mgnlDialogControlEdit");
        control.setCssStyles("width", this.getConfigValue("width", "100%"));
        this.drawHtmlPre(out);
        String width = this.getConfigValue("width", "100%");
        boolean preview = Boolean.valueOf(this.getConfigValue("preview", "true"));
        boolean extensionIsDisplayableImage = this.getImageExtensions().contains(control.getExtension().toLowerCase());
        boolean showImage = extensionIsDisplayableImage && preview;
        String htmlControlBrowse = control.getHtmlBrowse();
        StringBuffer htmlControlFileName = new StringBuffer();
        htmlControlFileName.append("<span class=\"mgnlDialogDescription\">" + this.getMessage("dialog.file.filename") + "</span>");
        htmlControlFileName.append(Spacer.getHtml((int)1, (int)1));
        htmlControlFileName.append(control.getHtmlFileName() + "<span id=\"" + this.getName() + "_fileNameExtension\">." + control.getExtension() + "</span>");
        String htmlContentEmpty = htmlControlBrowse + Spacer.getHtml((int)0, (int)0) + htmlControlFileName;
        out.write("<div id=\"" + this.getName() + "_contentDiv\" style=\"width:100%;\">");
        boolean exists = false;
        if (this.getStorageNode() != null) {
            exists = this.getStorageNode().getNodeData(this.getName()).isExist();
        }
        if (!exists) {
            out.write(htmlContentEmpty);
            out.write("</div>");
        }
        if (exists && showImage) {
            out.write("\n<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"" + width + "\"><tr><td>");
        }
        if (exists) {
            out.write(htmlControlFileName.toString());
            if (!showImage) {
                String iconPath = MIMEMapping.getMIMETypeIcon((String)control.getExtension());
                out.write(Spacer.getHtml((int)0, (int)0));
                out.write("<a href=" + this.getRequest().getContextPath() + control.getPath() + " target=\"_blank\">");
                out.write("<img src=\"" + this.getRequest().getContextPath() + iconPath + "\" class=\"" + "mgnlDialogFileIcon" + "\" border=\"0\">");
                out.write(this.getRequest().getContextPath() + this.getPreviewUrl() + "</a>");
            }
            out.write(Spacer.getHtml((int)12, (int)12));
            out.write(control.getHtmlRemove("mgnlDialogFileRemove('" + this.getName() + "');"));
            if (showImage) {
                out.write("</td></tr><tr><td class=\"mgnlDialogFileImage\">");
                int imgwidth = 150;
                int imgheight = 150;
                try {
                    imgwidth = Integer.parseInt(control.getImageWidth());
                    imgheight = Integer.parseInt(control.getImageHeight());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                int bigger = Math.max(imgwidth, imgheight);
                if (bigger > 150) {
                    imgwidth = 150;
                }
                out.write("<p><a href=\"");
                out.write(this.getRequest().getContextPath());
                out.write(MediaConfigurationManager.getInstance().getURIMappingPrefix());
                out.write(this.getFileURI(control));
                out.write("/" + control.getFileName() + "." + control.getExtension());
                out.write("\" target=\"_blank\">");
                out.write("<img border=\"0\" src=\"");
                out.write(this.getRequest().getContextPath());
                out.write(this.getPreviewUrl());
                out.write("\" class=\"");
                out.write("mgnlDialogFileImage");
                out.write("\" alt=\"");
                out.write(control.getFileName());
                out.write("\" title=\"");
                out.write(control.getFileName());
                out.write("\" /></a></p>\n");
                if (StringUtils.isNotEmpty((String)control.getImageWidth())) {
                    out.write("<p><em style='white-space:nowrap'>");
                    out.write(control.getImageWidth());
                    out.write(" x ");
                    out.write(control.getImageHeight());
                    out.write("</em></p>\n");
                }
                if (StringUtils.isNotEmpty((String)control.getImageWidth())) {
                    out.write("<p><em style='white-space:nowrap'>");
                    int w = Integer.parseInt(control.getImageWidth());
                    int h = Integer.parseInt(control.getImageHeight());
                    if (w > h) {
                        out.write("landscape");
                    } else if (h > w) {
                        out.write("portrait");
                    } else {
                        out.write("square");
                    }
                    out.write("</em></p>\n");
                }
                out.write("</td></tr></table>");
            }
        }
        out.write("</div>\n");
        out.write("<div style=\"position:absolute;top:-500px;left:-500px;visibility:hidden;\">\n<textarea id=\"");
        out.write(this.getName());
        out.write("_contentEmpty\">");
        out.write(htmlContentEmpty);
        out.write("</textarea>\n</div>\n");
        control.setSaveInfo(true);
        out.write(control.getHtmlSaveInfo());
        this.drawHtmlPost(out);
    }

    private String getPreviewUrl() {
        return MediaConfigurationManager.getInstance().getURIMappingPrefix() + this.getStorageNode().getHandle() + "/resolutions/thumbnail/" + this.getStorageNode().getName() + ".jpg";
    }
}

