/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;

public class PDIndexed
extends PDColorSpace {
    public static final String NAME = "Indexed";
    public static final String ABBREVIATED_NAME = "I";
    private COSArray array;

    public PDIndexed() {
        this.array = new COSArray();
        this.array.add(COSName.getPDFName(NAME));
        this.array.add(COSName.getPDFName("DeviceRGB"));
        this.array.add(new COSInteger(255));
        this.array.add(COSNull.NULL);
    }

    public PDIndexed(COSArray indexedArray) {
        this.array = indexedArray;
    }

    public int getNumberOfComponents() throws IOException {
        return this.getBaseColorSpace().getNumberOfComponents();
    }

    public String getName() {
        return NAME;
    }

    protected ColorSpace createColorSpace() throws IOException {
        throw new IOException("Not implemented");
    }

    public ColorModel createColorModel(int bpc) throws IOException {
        int size = this.getHighValue();
        byte[] index = this.getLookupData();
        PDColorSpace baseColorSpace = this.getBaseColorSpace();
        IndexColorModel cm = null;
        if (baseColorSpace instanceof PDDeviceRGB) {
            cm = new IndexColorModel(bpc, size + 1, index, 0, false);
        } else {
            ColorModel baseColorModel = baseColorSpace.createColorModel(bpc);
            if (baseColorModel.getTransferType() != 0) {
                throw new IOException("Not implemented");
            }
            byte[] r = new byte[size + 1];
            byte[] g = new byte[size + 1];
            byte[] b = new byte[size + 1];
            byte[] a = baseColorModel.hasAlpha() ? new byte[size + 1] : null;
            byte[] inData = new byte[baseColorModel.getNumComponents()];
            for (int i = 0; i <= size; ++i) {
                System.arraycopy(index, i * inData.length, inData, 0, inData.length);
                r[i] = (byte)baseColorModel.getRed(inData);
                g[i] = (byte)baseColorModel.getGreen(inData);
                b[i] = (byte)baseColorModel.getBlue(inData);
                if (a == null) continue;
                a[i] = (byte)baseColorModel.getAlpha(inData);
            }
            cm = a == null ? new IndexColorModel(bpc, size + 1, r, g, b) : new IndexColorModel(bpc, size + 1, r, g, b, a);
        }
        return cm;
    }

    public PDColorSpace getBaseColorSpace() throws IOException {
        COSBase base = this.array.getObject(1);
        return PDColorSpaceFactory.createColorSpace(base);
    }

    public void setBaseColorSpace(PDColorSpace base) {
        this.array.set(1, base.getCOSObject());
    }

    public int getHighValue() {
        return ((COSNumber)this.array.getObject(2)).intValue();
    }

    public void setHighValue(int high) {
        this.array.set(2, new COSInteger(high));
    }

    public int lookupColor(int lookupIndex, int componentNumber) throws IOException {
        PDColorSpace baseColor = this.getBaseColorSpace();
        byte[] data = this.getLookupData();
        int numberOfComponents = baseColor.getNumberOfComponents();
        return (data[lookupIndex * numberOfComponents + componentNumber] + 256) % 256;
    }

    private byte[] getLookupData() throws IOException {
        COSBase lookupTable = this.array.getObject(3);
        byte[] data = null;
        if (lookupTable instanceof COSString) {
            data = ((COSString)lookupTable).getBytes();
        } else if (lookupTable instanceof COSStream) {
            int amountRead;
            COSStream lookupStream = (COSStream)lookupTable;
            InputStream input = lookupStream.getUnfilteredStream();
            ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
            byte[] buffer = new byte[1024];
            while ((amountRead = input.read(buffer, 0, buffer.length)) != -1) {
                output.write(buffer, 0, amountRead);
            }
            data = output.toByteArray();
        } else if (lookupTable == null) {
            data = new byte[]{};
        } else {
            throw new IOException("Error: Unknown type for lookup table " + lookupTable);
        }
        return data;
    }

    public void setLookupColor(int lookupIndex, int componentNumber, int color) throws IOException {
        PDColorSpace baseColor = this.getBaseColorSpace();
        int numberOfComponents = baseColor.getNumberOfComponents();
        byte[] data = this.getLookupData();
        data[lookupIndex * numberOfComponents + componentNumber] = (byte)color;
        COSString string = new COSString(data);
        this.array.set(3, string);
    }
}

