/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfparser.BaseParser;

public class PDFObjectStreamParser
extends BaseParser {
    private static final Log log = LogFactory.getLog(PDFObjectStreamParser.class);
    private List streamObjects = null;
    private List objectNumbers = null;
    private COSStream stream;

    public PDFObjectStreamParser(COSStream strm, COSDocument doc) throws IOException {
        super(strm.getUnfilteredStream());
        this.setDocument(doc);
        this.stream = strm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException {
        try {
            int numberOfObjects = this.stream.getInt("N");
            this.objectNumbers = new ArrayList(numberOfObjects);
            this.streamObjects = new ArrayList(numberOfObjects);
            for (int i = 0; i < numberOfObjects; ++i) {
                int objectNumber = this.readInt();
                int offset = this.readInt();
                this.objectNumbers.add(new Integer(objectNumber));
            }
            COSObject object = null;
            COSBase cosObject = null;
            int objectCounter = 0;
            while ((cosObject = this.parseDirObject()) != null) {
                object = new COSObject(cosObject);
                object.setGenerationNumber(COSInteger.ZERO);
                COSInteger objNum = new COSInteger((Integer)this.objectNumbers.get(objectCounter));
                object.setObjectNumber(objNum);
                this.streamObjects.add(object);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("parsed=" + object));
                }
                ++objectCounter;
            }
        }
        finally {
            this.pdfSource.close();
        }
    }

    public List getObjects() {
        return this.streamObjects;
    }
}

