/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.cms.core.SystemProperty;
import info.magnolia.module.DefaultModuleVersionHandler;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.Delta;
import info.magnolia.module.delta.DeltaBuilder;
import info.magnolia.module.model.Version;
import it.openutils.mgnltasks.BootstrapMissingNodesTask;
import it.openutils.mgnltasks.ModuleConfigBootstrapTask;
import it.openutils.mgnltasks.UpdateModuleVersionTask;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleModuleVersionHandler
extends DefaultModuleVersionHandler {
    protected Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected List<String> excludedRepositoriesFromBootstrap = new ArrayList<String>();

    public SimpleModuleVersionHandler() {
        this.excludedRepositoriesFromBootstrap.add("website");
    }

    public void addExcludeRepositoryFromBootstrap(String repository) {
        this.excludedRepositoriesFromBootstrap.add(repository);
    }

    public void removeExcludeRepositoryFromBootstrap(String repository) {
        this.excludedRepositoriesFromBootstrap.remove(repository);
    }

    public List<Delta> getDeltas(InstallContext ctx, Version from) {
        if (from == null) {
            this.log.info("Actual version not set");
            List deltas = super.getDeltas(ctx, from);
            ((Delta)deltas.get(0)).getTasks().add(new BootstrapMissingNodesTask(ctx.getCurrentModuleDefinition().getName() + "-nooverwrite"));
            return deltas;
        }
        String modulename = ctx.getCurrentModuleDefinition().getName();
        Version to = ctx.getCurrentModuleDefinition().getVersion();
        ArrayList<Delta> deltas = new ArrayList<Delta>();
        if (SystemProperty.getBooleanProperty((String)(modulename + ".update.disabled"))) {
            return deltas;
        }
        if (!to.isEquivalent(from) || "${project.version}".equals(ObjectUtils.toString((Object)from)) || "SNAPSHOT".equals(from.getClassifier())) {
            this.log.info("Updating from version {}", (Object)from);
            DeltaBuilder delta = DeltaBuilder.update((Version)to, (String)"Update to current version");
            delta.getTasks().add(new ModuleConfigBootstrapTask(modulename, this.excludedRepositoriesFromBootstrap));
            delta.getTasks().add(new BootstrapMissingNodesTask(modulename + "-nooverwrite"));
            delta.getTasks().add(new UpdateModuleVersionTask());
            deltas.add((Delta)delta);
        } else {
            this.log.info("Version {} already installed, no update tasks to run", (Object)from);
        }
        return deltas;
    }
}

