/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.util.ContentUtil;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractRepositoryTask;
import info.magnolia.module.delta.TaskExecutionException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.RepositoryException;

public class SetNodeOrderTask
extends AbstractRepositoryTask {
    private String repository;
    private String parentNode;
    private String[] nodesOrder;

    public SetNodeOrderTask(String repository, String parentNode, String[] nodesOrder) {
        super("Set order in node " + parentNode, "Set order in node " + parentNode);
        this.repository = repository;
        this.parentNode = parentNode;
        this.nodesOrder = nodesOrder;
    }

    protected void doExecute(InstallContext installContext) throws RepositoryException, TaskExecutionException {
        Content parent = installContext.getHierarchyManager(this.repository).getContent(this.parentNode);
        List children = (List)ContentUtil.getAllChildren((Content)parent);
        if (children.isEmpty()) {
            children = (List)parent.getChildren(ItemType.CONTENTNODE);
        }
        final List<String> orderedList = Arrays.asList(this.nodesOrder);
        Collections.sort(children, new Comparator<Content>(){

            @Override
            public int compare(Content o1, Content o2) {
                Integer index1 = orderedList.indexOf(o1.getName());
                Integer index2 = orderedList.indexOf(o2.getName());
                if (index1 < 0) {
                    index1 = Integer.MAX_VALUE;
                }
                if (index2 < 0) {
                    index2 = Integer.MAX_VALUE;
                }
                return index2.compareTo(index1);
            }
        });
        Content previous = null;
        for (Content content : children) {
            if (previous != null) {
                parent.orderBefore(content.getName(), previous.getName());
            }
            previous = content;
        }
    }
}

