/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.search.QueryManager;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractRepositoryTask;
import info.magnolia.module.delta.TaskExecutionException;
import java.util.Collection;
import javax.jcr.RepositoryException;

public class ReplaceTemplateTask
extends AbstractRepositoryTask {
    private final String actualTemplate;
    private final String newTemplate;

    public ReplaceTemplateTask(String actualTemplate, String newTemplate) {
        super("Replacing template " + actualTemplate + " with " + newTemplate, "Replacing template " + actualTemplate + " with " + newTemplate);
        this.actualTemplate = actualTemplate;
        this.newTemplate = newTemplate;
    }

    protected void doExecute(InstallContext installContext) throws RepositoryException, TaskExecutionException {
        HierarchyManager hm = installContext.getHierarchyManager("website");
        QueryManager qm = hm.getQueryManager();
        StringBuilder query = new StringBuilder("//*[MetaData/mgnl:template ='");
        query.append(this.actualTemplate);
        query.append("']");
        String queryAAsString = query.toString();
        this.log.debug("Running query: {}", (Object)queryAAsString);
        Collection nodes = qm.createQuery(queryAAsString, "xpath").execute().getContent();
        for (Content page : nodes) {
            this.log.warn("Replacing template " + page.getMetaData().getTemplate() + " with {} in {}", (Object)this.newTemplate, (Object)page.getHandle());
            page.getMetaData().setTemplate(this.newTemplate);
        }
    }
}

