/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.util.ContentUtil;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractRepositoryTask;
import info.magnolia.module.delta.TaskExecutionException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.RepositoryException;

public class NodeSortTask
extends AbstractRepositoryTask {
    private String repository;
    private String node;
    private String property;

    public NodeSortTask(String repository, String node, String property) {
        super("Reorder " + node, "Reorder " + node);
        this.repository = repository;
        this.node = node;
        this.property = property;
    }

    public NodeSortTask(String repository, String node) {
        this(repository, node, null);
    }

    protected void doExecute(InstallContext ctx) throws RepositoryException, TaskExecutionException {
        HierarchyManager hm = ctx.getHierarchyManager(this.repository);
        Content parent = hm.getContent(this.node);
        List children = (List)ContentUtil.getAllChildren((Content)parent);
        if (children.isEmpty()) {
            children = (List)parent.getChildren(ItemType.CONTENTNODE);
        }
        if (this.property == null) {
            Collections.sort(children, new Comparator<Content>(){

                @Override
                public int compare(Content o1, Content o2) {
                    return o2.getName().compareTo(o1.getName());
                }
            });
        } else {
            Collections.sort(children, new Comparator<Content>(){

                @Override
                public int compare(Content o1, Content o2) {
                    return o2.getNodeData(NodeSortTask.this.property).getString().compareTo(o1.getNodeData(NodeSortTask.this.property).getString());
                }
            });
        }
        Content previous = null;
        for (Content content : children) {
            if (previous != null) {
                parent.orderBefore(content.getName(), previous.getName());
            }
            previous = content;
        }
    }
}

