/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.importexport.BootstrapUtil;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.BootstrapResourcesTask;
import info.magnolia.module.delta.TaskExecutionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleConfigBootstrapTask
extends BootstrapResourcesTask {
    private Logger log = LoggerFactory.getLogger(ModuleConfigBootstrapTask.class);
    private String modulename;
    private List<String> excludeRepositories = new ArrayList<String>();

    public ModuleConfigBootstrapTask(String modulename) {
        super("Bootstrap", "Bootstraps module configuration for " + modulename + " (will not overwrite website!).");
        this.modulename = modulename;
        this.excludeRepositories.add("website");
    }

    public ModuleConfigBootstrapTask(String modulename, List<String> excludeRepositories) {
        super("Bootstrap", "Bootstraps module configuration for " + modulename + " (will not overwrite website!).");
        this.modulename = modulename;
        this.excludeRepositories.addAll(excludeRepositories);
    }

    protected boolean acceptResource(InstallContext ctx, String name) {
        boolean accept = name.startsWith("/mgnl-bootstrap/" + this.modulename + "/") && name.endsWith(".xml");
        for (String repository : this.excludeRepositories) {
            accept = accept && !name.startsWith("/mgnl-bootstrap/" + this.modulename + "/" + repository);
        }
        if (accept) {
            this.log.debug("Importing file {}", (Object)name);
        }
        return accept;
    }

    public void execute(InstallContext installContext) throws TaskExecutionException {
        try {
            String[] resourcesToBootstrap = this.getResourcesToBootstrap(installContext);
            long millis = System.currentTimeMillis();
            this.log.info("{} bootstrap starting...", (Object)this.modulename);
            this.deleteNode(installContext, "/modules/" + this.modulename + "/dialogs");
            this.deleteNode(installContext, "/modules/" + this.modulename + "/templates");
            this.deleteNode(installContext, "/modules/" + this.modulename + "/paragraphs");
            this.deleteNode(installContext, "/modules/" + this.modulename + "/virtualURIMapping");
            BootstrapUtil.bootstrap((String[])resourcesToBootstrap, (int)1);
            this.log.info("{} bootstrap done in {} seconds", (Object)this.modulename, (Object)((System.currentTimeMillis() - millis) / 1000L));
        }
        catch (IOException e) {
            throw new TaskExecutionException("Could not bootstrap: " + e.getMessage());
        }
        catch (RepositoryException e) {
            throw new TaskExecutionException("Could not bootstrap: " + e.getMessage());
        }
    }

    protected void deleteNode(InstallContext installContext, String nodePath) throws RepositoryException {
        HierarchyManager hm = installContext.getHierarchyManager("config");
        if (hm.isExist(nodePath)) {
            this.log.warn("Deleting node {}", (Object)nodePath);
            hm.delete(nodePath);
        }
    }
}

