/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.ItemType;
import info.magnolia.cms.util.ContentUtil;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractRepositoryTask;
import info.magnolia.module.delta.TaskExecutionException;
import java.util.List;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateDefaultRepositoryAclForAllUsersTask
extends AbstractRepositoryTask {
    private static Logger log = LoggerFactory.getLogger(CreateDefaultRepositoryAclForAllUsersTask.class);
    private String repository;
    private long permissions;

    public CreateDefaultRepositoryAclForAllUsersTask(String repository, long permissions) {
        super("Adding permissions on " + repository + " repository", "Adding permissions on " + repository + " repository");
        this.repository = repository;
        this.permissions = permissions;
    }

    protected void doExecute(InstallContext ctx) throws RepositoryException, TaskExecutionException {
        HierarchyManager hm = ctx.getHierarchyManager("userroles");
        Content parentNode = hm.getContent("/");
        List childNodes = ContentUtil.collectAllChildren((Content)parentNode, (ItemType)ItemType.ROLE);
        for (Content content : childNodes) {
            this.operateOnChildNode(content, ctx);
        }
    }

    protected void operateOnChildNode(Content node, InstallContext ctx) throws RepositoryException {
        String aclpath = "acl_" + this.repository;
        if (!node.hasContent(aclpath)) {
            log.info("adding permissions on {} to role {}", (Object)this.repository, (Object)node.getName());
            Content aclnode = node.createContent(aclpath, ItemType.CONTENTNODE);
            Content permNode = aclnode.createContent("0", ItemType.CONTENTNODE);
            permNode.createNodeData("path", (Object)"/*");
            permNode.createNodeData("permissions", (Object)new Long(this.permissions));
        }
    }
}

