/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.NodeData;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractTask;
import info.magnolia.module.delta.Task;
import info.magnolia.module.delta.TaskExecutionException;
import java.util.List;
import javax.jcr.RepositoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConditionalTask
extends AbstractTask {
    protected String workspace;
    protected String handle;
    protected List<Task> tasks;

    public ConditionalTask(String workspace, String handle, List<Task> tasks) {
        super("Conditional task", "Execute task if exists " + handle + " in " + workspace);
        this.tasks = tasks;
        this.handle = handle;
        this.workspace = workspace;
    }

    public void execute(InstallContext installContext) throws TaskExecutionException {
        HierarchyManager hm = installContext.getHierarchyManager(this.workspace);
        try {
            if (this.verifyCondition(hm, this.handle)) {
                for (Task t : this.tasks) {
                    t.execute(installContext);
                }
            }
        }
        catch (RepositoryException e) {
            throw new TaskExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean existsNode(HierarchyManager hm, String handle) {
        return hm.isExist(handle);
    }

    public boolean existsNodedata(HierarchyManager hm, String handle, String nodedata) throws RepositoryException {
        return hm.getContent(handle).hasNodeData(nodedata);
    }

    public boolean nodeDataEquals(HierarchyManager hm, String handle, String nodedata, Object value) throws RepositoryException {
        return value.equals(NodeDataUtil.getValueObject((NodeData)hm.getContent(handle).getNodeData(nodedata)));
    }

    public abstract boolean verifyCondition(HierarchyManager var1, String var2) throws RepositoryException;
}

