/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.util.ContentUtil;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractRepositoryTask;
import info.magnolia.module.delta.TaskExecutionException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;

public class ChangeExistingPropertyTask
extends AbstractRepositoryTask {
    private final String workspaceName;
    private final String nodePath;
    private final String propertyName;
    private final Object newPropertyValue;
    private final Object previousPropertyValue;

    public ChangeExistingPropertyTask(String workspaceName, String nodePath, String propertyName, Object previousPropertyValue, Object newPropertyValue) {
        super("Checking the value of " + nodePath + "/" + propertyName, "Creating property " + nodePath + "/" + propertyName + " and setting its value to " + newPropertyValue + " if the previous value is " + previousPropertyValue);
        this.workspaceName = workspaceName;
        this.nodePath = nodePath;
        this.propertyName = propertyName;
        this.previousPropertyValue = previousPropertyValue;
        this.newPropertyValue = newPropertyValue;
    }

    protected void doExecute(InstallContext ctx) throws RepositoryException, TaskExecutionException {
        HierarchyManager hm = ctx.getHierarchyManager(this.workspaceName);
        Content node = ContentUtil.createPath((HierarchyManager)hm, (String)this.nodePath, (boolean)false);
        if (node.hasNodeData(this.propertyName) && StringUtils.equals((String)node.getNodeData(this.propertyName).getString(), (String)this.previousPropertyValue.toString())) {
            NodeDataUtil.getOrCreateAndSet((Content)node, (String)this.propertyName, (Object)this.newPropertyValue);
        }
    }
}

