/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.NodeData;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractRepositoryTask;
import info.magnolia.module.delta.Task;
import info.magnolia.module.delta.TaskExecutionException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeDefaultPasswordTask
extends AbstractRepositoryTask
implements Task {
    private String user;
    private String defaultPassword;
    private String newpassword;
    private Logger log = LoggerFactory.getLogger(ChangeDefaultPasswordTask.class);

    public ChangeDefaultPasswordTask(String user, String defaultPassword, String newpassword) {
        super("Default password check", "Checking default password for " + user);
        this.user = user;
        this.defaultPassword = defaultPassword;
        this.newpassword = newpassword;
    }

    protected void doExecute(InstallContext installContext) throws RepositoryException, TaskExecutionException {
        HierarchyManager hm = installContext.getHierarchyManager("users");
        Content role = hm.getContent(this.user);
        NodeData pwdNodeData = role.getNodeData("pswd");
        String actualPassword = pwdNodeData.getString();
        if (StringUtils.equals((String)this.defaultPassword, (String)StringUtils.trim((String)actualPassword))) {
            this.log.info("Found default password for {}, setting new password", (Object)this.user);
            pwdNodeData.setValue(this.newpassword);
        }
    }
}

