/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.search.QueryManager;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractRepositoryTask;
import info.magnolia.module.delta.TaskExecutionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseCheckMissingTask
extends AbstractRepositoryTask {
    private final String templateOrParagraph;
    private final String nodetype;

    public BaseCheckMissingTask(String templateOrParagraph, String nodetype) {
        super("Check " + templateOrParagraph + "s task", "Checking pages configured with missing " + templateOrParagraph + "s");
        this.templateOrParagraph = templateOrParagraph;
        this.nodetype = nodetype;
    }

    protected void doExecute(InstallContext installContext) throws RepositoryException, TaskExecutionException {
        QueryManager configQueryManager = installContext.getHierarchyManager("config").getQueryManager();
        Collection templates = configQueryManager.createQuery("//modules/*/" + this.templateOrParagraph + "s/*", "xpath").execute().getContent("mgnl:contentNode");
        ArrayList<String> templ = new ArrayList<String>();
        for (Content template : templates) {
            templ.add(template.getName());
        }
        this.checkInvalidPages(installContext, templ);
    }

    private void checkInvalidPages(InstallContext installContext, List<String> templates) throws RepositoryException, InvalidQueryException {
        HierarchyManager hm = installContext.getHierarchyManager("website");
        QueryManager qm = hm.getQueryManager();
        StringBuilder query = new StringBuilder("//*[jcr:primaryType='" + this.nodetype + "' and MetaData/mgnl:template and not(");
        Iterator<String> nameIterator = templates.iterator();
        while (nameIterator.hasNext()) {
            String template = nameIterator.next();
            query.append("MetaData/mgnl:template='");
            query.append(template);
            query.append("'");
            if (!nameIterator.hasNext()) continue;
            query.append(" or ");
        }
        query.append(")]");
        String queryAAsString = query.toString();
        this.log.debug("Running query: {}", (Object)queryAAsString);
        Collection nodes = qm.createQuery(queryAAsString, "xpath").execute().getContent(this.nodetype);
        int count = 0;
        StringBuilder sb = new StringBuilder();
        for (Content page : nodes) {
            String template = page.getMetaData().getTemplate();
            if (!StringUtils.isNotEmpty((String)template)) continue;
            ++count;
            sb.append(page.getHandle());
            sb.append("   ");
            sb.append(template);
            sb.append("\n");
        }
        if (count > 0) {
            this.log.error("Found {} pages with invalid " + this.templateOrParagraph + "s:\n{}", (Object)count, (Object)sb.toString());
        }
    }
}

