/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.security.AccessDeniedException;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractRepositoryTask;
import info.magnolia.module.delta.Task;
import info.magnolia.module.delta.TaskExecutionException;
import java.util.Collection;
import javax.jcr.RepositoryException;

public class AnonymousUserSetupTask
extends AbstractRepositoryTask
implements Task {
    private boolean allowAccess;

    public AnonymousUserSetupTask(boolean allowAccess) {
        super("Setup anonymous user", allowAccess ? "Adding access to anonymous user" : "Removing access to anonymous user");
        this.allowAccess = allowAccess;
    }

    protected void doExecute(InstallContext installContext) throws RepositoryException, TaskExecutionException {
        HierarchyManager hm = installContext.getHierarchyManager("userroles");
        Content role = hm.getContent("/anonymous");
        this.setupAcl(role, "website", "/*", this.allowAccess ? 8L : 0L);
        this.setupAcl(role, "uri", "/*", this.allowAccess ? 63L : 0L);
        this.setupAcl(role, "uri", "/.magnolia*", 0L);
    }

    private void setupAcl(Content role, String repository, String path, long newpermissions) throws RepositoryException, AccessDeniedException {
        Content acls = role.getChildByName("acl_" + repository);
        Collection children = acls.getChildren();
        boolean found = false;
        for (Content acl : children) {
            String aclPath = acl.getNodeData("path").getString();
            if (!path.equals(aclPath)) continue;
            found = true;
            long permissions = acl.getNodeData("permissions").getLong();
            if (permissions == newpermissions) continue;
            NodeDataUtil.getOrCreate((Content)acl, (String)"permissions").setValue(newpermissions);
        }
        if (!found) {
            this.log.warn("Security not configured on anonymous user! No acl for {} found on {}", (Object)path, (Object)repository);
        }
    }
}

