/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.mgnltasks;

import info.magnolia.cms.core.Content;
import info.magnolia.cms.core.HierarchyManager;
import info.magnolia.cms.core.Path;
import info.magnolia.cms.security.AccessDeniedException;
import info.magnolia.cms.util.NodeDataUtil;
import info.magnolia.module.InstallContext;
import info.magnolia.module.delta.AbstractRepositoryTask;
import info.magnolia.module.delta.Task;
import info.magnolia.module.delta.TaskExecutionException;
import java.util.Collection;
import javax.jcr.RepositoryException;

public class AddPermissionTask
extends AbstractRepositoryTask
implements Task {
    private final String role;
    private final String repo;
    private final String path;
    private final long permission;

    public AddPermissionTask(String role, String repo, String path, long permission) {
        super("Setup permissions on " + repo + ":" + path + " for " + role, "Setup permissions on " + repo + ":" + path + " for " + role);
        this.role = role;
        this.repo = repo;
        this.path = path;
        this.permission = permission;
    }

    protected void doExecute(InstallContext installContext) throws RepositoryException, TaskExecutionException {
        HierarchyManager hm = installContext.getHierarchyManager("userroles");
        Content roleNode = hm.getContent("/" + this.role);
        this.setupAcl(roleNode, this.repo, this.path, this.permission);
    }

    private void setupAcl(Content role, String repository, String path, long newpermissions) throws RepositoryException, AccessDeniedException {
        Content acls = role.getChildByName("acl_" + repository);
        if (acls == null) {
            acls = role.createContent("acl_" + repository, "mgnl:contentNode");
        }
        Collection children = acls.getChildren();
        boolean found = false;
        for (Content acl : children) {
            String aclPath = acl.getNodeData("path").getString();
            if (!path.equals(aclPath)) continue;
            found = true;
            long permissions = acl.getNodeData("permissions").getLong();
            if (permissions == newpermissions) continue;
            this.setPermission(acl, path, newpermissions);
        }
        if (!found) {
            Content acl = acls.createContent(Path.getUniqueLabel((Content)acls, (String)"0"), "mgnl:contentNode");
            this.setPermission(acl, path, newpermissions);
        }
    }

    private void setPermission(Content acl, String path, long newpermissions) throws RepositoryException, AccessDeniedException {
        this.log.info("Setting permissions for {} to {}", (Object)(this.repo + ":" + path), (Object)this.role);
        NodeDataUtil.getOrCreate((Content)acl, (String)"path").setValue(path);
        NodeDataUtil.getOrCreate((Content)acl, (String)"permissions").setValue(newpermissions);
    }
}

