/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.elfunctions;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang.math.NumberUtils;

public class ElStringUtils {
    public static String space() {
        return " ";
    }

    public static String tab() {
        return "\t";
    }

    public static String newline() {
        return "\n";
    }

    public static String escapeJsText(String text, boolean dbl) {
        String repl = dbl ? "\"" : "'";
        String with = "\\" + repl;
        return repl + (text != null ? StringUtils.replace((String)text, (String)repl, (String)with) : "") + repl;
    }

    public static String adaptStringLength(String value, int maxLength, String ellipses) {
        if (value != null && value.length() > maxLength) {
            return value.substring(0, maxLength) + ellipses;
        }
        return value;
    }

    public static String stripHtmlTags(String string) {
        if (StringUtils.isNotBlank((String)string)) {
            return StringUtils.remove((String)StringUtils.remove((String)string.replaceAll("<(.|\n)+?>", ""), (char)'\r'), (char)'\n').trim();
        }
        return null;
    }

    public static String[] splitNewlines(String string) {
        return StringUtils.splitPreserveAllTokens((String)StringUtils.replace((String)string, (String)"\r", (String)""), (char)'\n');
    }

    public static String[] splitOnTabs(String string) {
        return StringUtils.splitPreserveAllTokens((String)string, (char)'\t');
    }

    public static boolean endsWith(String string, String suffix) {
        return string.endsWith(suffix);
    }

    public static Long toLong(String value) {
        return NumberUtils.toLong((String)value, (long)0L);
    }

    public static Long toRoundedLong(String value) {
        double doubleValue = NumberUtils.toDouble((String)value);
        if (doubleValue != 0.0) {
            return Math.round(doubleValue);
        }
        return 0L;
    }

    public static Long toFloorLong(String value) {
        double doubleValue = NumberUtils.toDouble((String)value);
        if (doubleValue != 0.0) {
            return Math.round(Math.floor(doubleValue));
        }
        return 0L;
    }

    public static Long toCeilLong(String value) {
        double doubleValue = NumberUtils.toDouble((String)value);
        if (doubleValue != 0.0) {
            return Math.round(Math.ceil(doubleValue));
        }
        return 0L;
    }

    public static String shorten(String text, int lines, int numOfCharsPerLine, String ellipses) {
        if (text == null) {
            return null;
        }
        String wrapped = WordUtils.wrap((String)text, (int)numOfCharsPerLine, (String)SystemUtils.LINE_SEPARATOR, (boolean)true);
        int j = 0;
        for (int lineCount = 0; lineCount < lines && j != -1; ++lineCount) {
            j = StringUtils.indexOf((String)wrapped, (String)SystemUtils.LINE_SEPARATOR, (int)(j + 1));
        }
        return j != -1 ? StringUtils.substring((String)wrapped, (int)0, (int)j) + (ellipses == null ? "" : ellipses) : text;
    }

    public static String urlencode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return string;
        }
    }

    public static String urldecode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return string;
        }
    }
}

