/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.elfunctions;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateElUtils {
    private static Logger log = LoggerFactory.getLogger(DateElUtils.class);
    private static final int NO_FORMAT = -1337;
    private static final String FORMAT_SHORT = "short";
    private static final String FORMAT_MEDIUM = "medium";
    private static final String FORMAT_LONG = "long";
    private static final String FORMAT_FULL = "full";

    private static int getFormat(String pattern) {
        int out = -1337;
        if (!StringUtils.isBlank((String)pattern)) {
            if (FORMAT_SHORT.equalsIgnoreCase(pattern)) {
                out = 3;
            } else if (FORMAT_MEDIUM.equalsIgnoreCase(pattern)) {
                out = 2;
            } else if (FORMAT_LONG.equalsIgnoreCase(pattern)) {
                out = 1;
            } else if (FORMAT_FULL.equalsIgnoreCase(pattern)) {
                out = 0;
            }
        }
        return out;
    }

    private static String format(Calendar dateTime, String pattern, boolean date, boolean time, Locale locale) {
        String[] split;
        if (dateTime == null || StringUtils.isBlank((String)pattern)) {
            return "";
        }
        int dateStyle = -1337;
        int timeStyle = -1337;
        if ((date || time) && (dateStyle = (timeStyle = DateElUtils.getFormat(pattern.trim()))) == -1337 && date && time && (split = pattern.split(";")).length == 2) {
            dateStyle = DateElUtils.getFormat(split[0].trim());
            timeStyle = DateElUtils.getFormat(split[1].trim());
        }
        FastDateFormat instance = date && time && dateStyle != -1337 && timeStyle != -1337 ? FastDateFormat.getDateTimeInstance((int)dateStyle, (int)timeStyle, (Locale)locale) : (date && dateStyle != -1337 ? FastDateFormat.getDateInstance((int)dateStyle, (Locale)locale) : (time && timeStyle != -1337 ? FastDateFormat.getTimeInstance((int)timeStyle, (Locale)locale) : FastDateFormat.getInstance((String)pattern, (Locale)locale)));
        return instance.format(dateTime);
    }

    public static String formatDate(Calendar date, String pattern, String languageId) {
        return DateElUtils.format(date, pattern, true, false, new Locale(languageId));
    }

    public static String formatTime(Calendar time, String pattern, String languageId) {
        return DateElUtils.format(time, pattern, false, true, new Locale(languageId));
    }

    public static String formatDateTime(Calendar dateTime, String pattern, String languageId) {
        return DateElUtils.format(dateTime, pattern, true, true, new Locale(languageId));
    }

    public static String formatDateTimeWithLocale(Calendar dateTime, String languageId, String pattern) {
        return DateElUtils.format(dateTime, pattern, true, true, new Locale(languageId));
    }

    public static String formatInterval(Long millisInterval) {
        if (millisInterval == null) {
            return "";
        }
        long secondsInterval = millisInterval / 1000L;
        long years = secondsInterval / 31536000L;
        long days = secondsInterval % 31536000L / 86400L;
        long hours = secondsInterval % 86400L / 3600L;
        long minutes = secondsInterval % 3600L / 60L;
        long seconds = secondsInterval % 60L;
        StringBuilder out = new StringBuilder();
        if (years > 0L) {
            out.append(years).append("y ");
        }
        if (days > 0L) {
            out.append(days).append("d ");
        }
        if (hours > 0L) {
            out.append(hours).append("h ");
        }
        if (minutes > 0L) {
            out.append(minutes).append("m ");
        }
        out.append(seconds).append('s');
        return out.toString();
    }

    public static Long getMillisFromNow(Calendar date) {
        if (date == null) {
            return 0L;
        }
        return System.currentTimeMillis() - date.getTimeInMillis();
    }

    public static Calendar parseDate(String date, String pattern) {
        if (StringUtils.isNotEmpty((String)date) && StringUtils.isNotEmpty((String)pattern)) {
            Calendar cal = Calendar.getInstance();
            try {
                cal.setTime(new SimpleDateFormat(pattern).parse(date));
                return cal;
            }
            catch (ParseException e) {
                log.warn("unable to parse date from string: " + date + " with pattern: " + pattern, (Throwable)e);
            }
        }
        return null;
    }

    public static Calendar parseXsdDate(String xsdDate) {
        String[] dateTime = xsdDate.split("T");
        String date = dateTime[0];
        String time = dateTime[1];
        String[] ymd = date.split("-");
        int year = Integer.parseInt(ymd[0]);
        int month = Integer.parseInt(ymd[1]) - 1;
        int day = Integer.parseInt(ymd[2]);
        String[] hms = time.split(":");
        int hour = Integer.parseInt(hms[0]);
        int minutes = Integer.parseInt(hms[1]);
        int seconds = Integer.parseInt(hms[2].substring(0, 2));
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, day, hour, minutes, seconds);
        cal.set(14, 0);
        return cal;
    }

    public static Calendar getMidnight00(Calendar calendar) {
        Calendar midniteCalendar = (Calendar)calendar.clone();
        midniteCalendar.set(11, 0);
        midniteCalendar.set(12, 0);
        midniteCalendar.set(13, 0);
        midniteCalendar.set(14, 0);
        return midniteCalendar;
    }

    public static Calendar getMidnight24(Calendar calendar) {
        Calendar midniteCalendar = (Calendar)calendar.clone();
        midniteCalendar.add(5, 1);
        midniteCalendar.set(11, 0);
        midniteCalendar.set(12, 0);
        midniteCalendar.set(13, 0);
        midniteCalendar.set(14, 0);
        return midniteCalendar;
    }
}

