/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.util;

import com.flazr.util.Utils;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueToEnum<T extends Enum<T>> {
    private final Enum[] lookupArray;
    private final int maxIndex;

    public ValueToEnum(T[] enumValues) {
        int[] lookupIndexes = new int[enumValues.length];
        for (int i = 0; i < enumValues.length; ++i) {
            lookupIndexes[i] = ((IntValue)enumValues[i]).intValue();
        }
        Arrays.sort(lookupIndexes);
        this.maxIndex = lookupIndexes[lookupIndexes.length - 1];
        this.lookupArray = new Enum[this.maxIndex + 1];
        for (T t : enumValues) {
            this.lookupArray[((IntValue)t).intValue()] = t;
        }
    }

    public T valueToEnum(int i) {
        Enum t;
        try {
            t = this.lookupArray[i];
        }
        catch (Exception e) {
            throw new RuntimeException(this.getErrorLogMessage(i) + ", " + e);
        }
        if (t == null) {
            throw new RuntimeException(this.getErrorLogMessage(i) + ", no match found in lookup");
        }
        return (T)t;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    private String getErrorLogMessage(int i) {
        return "bad value / byte: " + i + " (hex: " + Utils.toHex((byte)i) + ")";
    }

    public static interface IntValue {
        public int intValue();
    }
}

