/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.rtmp.server;

import com.flazr.rtmp.RtmpMessage;
import com.flazr.util.Utils;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerStream {
    private final String name;
    private final PublishType publishType;
    private final ChannelGroup subscribers;
    private final List<RtmpMessage> configMessages;
    private Channel publisher;

    public ServerStream(String rawName, String typeString) {
        this.name = Utils.trimSlashes(rawName).toLowerCase();
        if (typeString != null) {
            this.publishType = PublishType.parse(typeString);
            this.subscribers = new DefaultChannelGroup(this.name);
            this.configMessages = new ArrayList<RtmpMessage>();
        } else {
            this.publishType = null;
            this.subscribers = null;
            this.configMessages = null;
        }
    }

    public boolean isLive() {
        return this.publishType != null && this.publishType == PublishType.LIVE;
    }

    public PublishType getPublishType() {
        return this.publishType;
    }

    public ChannelGroup getSubscribers() {
        return this.subscribers;
    }

    public String getName() {
        return this.name;
    }

    public List<RtmpMessage> getConfigMessages() {
        return this.configMessages;
    }

    public void addConfigMessage(RtmpMessage message) {
        this.configMessages.add(message);
    }

    public void setPublisher(Channel publisher) {
        this.publisher = publisher;
        this.configMessages.clear();
    }

    public Channel getPublisher() {
        return this.publisher;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[name: '").append(this.name);
        sb.append("' type: ").append((Object)this.publishType);
        sb.append(" publisher: ").append(this.publisher);
        sb.append(" subscribers: ").append(this.subscribers);
        sb.append(" config: ").append(this.configMessages);
        sb.append(']');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PublishType {
        LIVE,
        APPEND,
        RECORD;


        public String asString() {
            return this.name().toLowerCase();
        }

        public static PublishType parse(String raw) {
            return PublishType.valueOf(raw.toUpperCase());
        }
    }
}

