/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.rtmp.server;

import com.flazr.rtmp.RtmpMessage;
import com.flazr.rtmp.RtmpPublisher;
import com.flazr.rtmp.RtmpReader;
import com.flazr.rtmp.RtmpWriter;
import com.flazr.rtmp.message.Audio;
import com.flazr.rtmp.message.BytesRead;
import com.flazr.rtmp.message.ChunkSize;
import com.flazr.rtmp.message.Command;
import com.flazr.rtmp.message.Control;
import com.flazr.rtmp.message.DataMessage;
import com.flazr.rtmp.message.Metadata;
import com.flazr.rtmp.message.SetPeerBw;
import com.flazr.rtmp.message.Video;
import com.flazr.rtmp.message.WindowAckSize;
import com.flazr.rtmp.server.RtmpServer;
import com.flazr.rtmp.server.ServerApplication;
import com.flazr.rtmp.server.ServerStream;
import com.flazr.util.ChannelUtils;
import java.util.ArrayList;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.WriteCompletionEvent;
import org.jboss.netty.channel.group.ChannelGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelPipelineCoverage(value="one")
public class ServerHandler
extends SimpleChannelHandler {
    private static final Logger logger = LoggerFactory.getLogger(ServerHandler.class);
    private int bytesReadWindow = 2500000;
    private long bytesRead;
    private long bytesReadLastSent;
    private long bytesWritten;
    private int bytesWrittenWindow = 2500000;
    private int bytesWrittenLastReceived;
    private ServerApplication application;
    private String clientId;
    private String playName;
    private int streamId;
    private int bufferDuration;
    private RtmpPublisher publisher;
    private ServerStream subscriberStream;
    private RtmpWriter recorder;
    private boolean aggregateModeEnabled = true;

    public void setAggregateModeEnabled(boolean aggregateModeEnabled) {
        this.aggregateModeEnabled = aggregateModeEnabled;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) {
        RtmpServer.CHANNELS.add((Object)e.getChannel());
        logger.info("opened channel: {}", (Object)e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        ChannelUtils.exceptionCaught(e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
        logger.info("channel closed: {}", (Object)e);
        if (this.publisher != null) {
            this.publisher.close();
        }
        if (this.recorder != null) {
            this.recorder.close();
        }
        this.unpublishIfLive();
    }

    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
        this.bytesWritten += (long)e.getWrittenAmount();
        super.writeComplete(ctx, e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent me) {
        if (this.publisher != null && this.publisher.handle(me)) {
            return;
        }
        Channel channel = me.getChannel();
        RtmpMessage message = (RtmpMessage)me.getMessage();
        this.bytesRead += (long)message.getHeader().getSize();
        if (this.bytesRead - this.bytesReadLastSent > (long)this.bytesReadWindow) {
            logger.info("sending bytes read ack after: {}", (Object)this.bytesRead);
            BytesRead ack = new BytesRead(this.bytesRead);
            channel.write((Object)ack);
            this.bytesReadLastSent = this.bytesRead;
        }
        block0 : switch (message.getHeader().getMessageType()) {
            case CHUNK_SIZE: {
                break;
            }
            case CONTROL: {
                Control control = (Control)message;
                switch (control.getType()) {
                    case SET_BUFFER: {
                        logger.debug("received set buffer: {}", (Object)control);
                        this.bufferDuration = control.getBufferLength();
                        if (this.publisher == null) break block0;
                        this.publisher.setBufferDuration(this.bufferDuration);
                        break;
                    }
                    default: {
                        logger.info("ignored control: {}", (Object)control);
                        break;
                    }
                }
                break;
            }
            case COMMAND_AMF0: 
            case COMMAND_AMF3: {
                Command command = (Command)message;
                String name = command.getName();
                if (name.equals("connect")) {
                    this.connectResponse(channel, command);
                } else if (name.equals("createStream")) {
                    this.streamId = 1;
                    channel.write((Object)Command.createStreamSuccess(command.getTransactionId(), this.streamId));
                } else if (name.equals("play")) {
                    this.playResponse(channel, command);
                } else if (name.equals("deleteStream")) {
                    int deleteStreamId = ((Double)command.getArg(0)).intValue();
                    logger.info("deleting stream id: {}", (Object)deleteStreamId);
                } else if (name.equals("closeStream")) {
                    int clientStreamId = command.getHeader().getStreamId();
                    logger.info("closing stream id: {}", (Object)clientStreamId);
                    this.unpublishIfLive();
                } else if (name.equals("pause")) {
                    this.pauseResponse(channel, command);
                } else if (name.equals("seek")) {
                    this.seekResponse(channel, command);
                } else if (name.equals("publish")) {
                    this.publishResponse(channel, command);
                } else {
                    logger.warn("ignoring command: {}", (Object)command);
                    this.fireNext(channel);
                }
                return;
            }
            case METADATA_AMF0: 
            case METADATA_AMF3: {
                Metadata meta = (Metadata)message;
                if (meta.getName().equals("onMetaData")) {
                    logger.info("adding onMetaData message: {}", (Object)meta);
                    meta.setDuration(-1.0);
                    this.subscriberStream.addConfigMessage(meta);
                }
                this.broadcast(message);
                break;
            }
            case AUDIO: 
            case VIDEO: {
                if (((DataMessage)message).isConfig()) {
                    logger.info("adding config message: {}", (Object)message);
                    this.subscriberStream.addConfigMessage(message);
                }
            }
            case AGGREGATE: {
                this.broadcast(message);
                break;
            }
            case BYTES_READ: {
                BytesRead bytesReadByClient = (BytesRead)message;
                this.bytesWrittenLastReceived = bytesReadByClient.getValue();
                logger.debug("bytes read ack from client: {}, actual: {}", (Object)bytesReadByClient, (Object)this.bytesWritten);
                break;
            }
            case WINDOW_ACK_SIZE: {
                WindowAckSize was = (WindowAckSize)message;
                if (was.getValue() == this.bytesReadWindow) break;
                channel.write((Object)SetPeerBw.dynamic(this.bytesReadWindow));
                break;
            }
            case SET_PEER_BW: {
                SetPeerBw spb = (SetPeerBw)message;
                if (spb.getValue() == this.bytesWrittenWindow) break;
                channel.write((Object)new WindowAckSize(this.bytesWrittenWindow));
                break;
            }
            default: {
                logger.warn("ignoring message: {}", (Object)message);
            }
        }
        this.fireNext(channel);
    }

    private void fireNext(Channel channel) {
        if (this.publisher != null && this.publisher.isStarted() && !this.publisher.isPaused()) {
            this.publisher.fireNext(channel, 0L);
        }
    }

    private RtmpMessage[] getStartMessages(RtmpMessage variation) {
        ArrayList<RtmpMessage> list = new ArrayList<RtmpMessage>();
        list.add(new ChunkSize(4096));
        list.add(Control.streamIsRecorded(this.streamId));
        list.add(Control.streamBegin(this.streamId));
        if (variation != null) {
            list.add(variation);
        }
        list.add(Command.playStart(this.playName, this.clientId));
        list.add(Metadata.rtmpSampleAccess());
        list.add(Audio.empty());
        list.add(Metadata.dataStart());
        return list.toArray(new RtmpMessage[list.size()]);
    }

    private void broadcast(RtmpMessage message) {
        this.subscriberStream.getSubscribers().write((Object)message);
        if (this.recorder != null) {
            this.recorder.write(message);
        }
    }

    private void writeToStream(Channel channel, RtmpMessage message) {
        if (message.getHeader().getChannelId() > 2) {
            message.getHeader().setStreamId(this.streamId);
        }
        channel.write((Object)message);
    }

    private void connectResponse(Channel channel, Command connect) {
        String appName = (String)connect.getObject().get("app");
        this.clientId = channel.getId() + "";
        this.application = ServerApplication.get(appName);
        logger.info("connect, client id: {}, application: {}", (Object)this.clientId, (Object)this.application);
        channel.write((Object)new WindowAckSize(this.bytesWrittenWindow));
        channel.write((Object)SetPeerBw.dynamic(this.bytesReadWindow));
        channel.write((Object)Control.streamBegin(this.streamId));
        Command result = Command.connectSuccess(connect.getTransactionId());
        channel.write((Object)result);
        channel.write((Object)Command.onBWDone());
    }

    private void playResponse(Channel channel, Command play) {
        int playStart = -2;
        int playLength = -1;
        if (play.getArgCount() > 1) {
            playStart = ((Double)play.getArg(1)).intValue();
        }
        if (play.getArgCount() > 2) {
            playLength = ((Double)play.getArg(2)).intValue();
        }
        boolean playReset = play.getArgCount() > 3 ? (Boolean)play.getArg(3) : true;
        Command playResetCommand = playReset ? Command.playReset(this.playName, this.clientId) : null;
        String clientPlayName = (String)play.getArg(0);
        ServerStream stream = this.application.getStream(clientPlayName);
        logger.debug("play name {}, start {}, length {}, reset {}", new Object[]{clientPlayName, playStart, playLength, playReset});
        if (stream.isLive()) {
            for (RtmpMessage message : this.getStartMessages(playResetCommand)) {
                this.writeToStream(channel, message);
            }
            boolean videoConfigPresent = false;
            for (RtmpMessage message : stream.getConfigMessages()) {
                logger.info("writing start meta / config: {}", (Object)message);
                if (message.getHeader().isVideo()) {
                    videoConfigPresent = true;
                }
                this.writeToStream(channel, message);
            }
            if (!videoConfigPresent) {
                this.writeToStream(channel, (RtmpMessage)Video.empty());
            }
            stream.getSubscribers().add((Object)channel);
            logger.info("client requested live stream: {}, added to stream: {}", (Object)clientPlayName, (Object)stream);
            return;
        }
        if (!clientPlayName.equals(this.playName)) {
            this.playName = clientPlayName;
            RtmpReader reader = this.application.getReader(this.playName);
            if (reader == null) {
                channel.write((Object)Command.playFailed(this.playName, this.clientId));
                return;
            }
            this.publisher = new RtmpPublisher(reader, this.streamId, this.bufferDuration, true, this.aggregateModeEnabled){

                protected RtmpMessage[] getStopMessages(long timePosition) {
                    return new RtmpMessage[]{Metadata.onPlayStatus(timePosition / 1000L, ServerHandler.this.bytesWritten), Command.playStop(ServerHandler.this.playName, ServerHandler.this.clientId), Control.streamEof(ServerHandler.this.streamId)};
                }
            };
        }
        this.publisher.start(channel, playStart, playLength, this.getStartMessages(playResetCommand));
    }

    private void pauseResponse(Channel channel, Command command) {
        if (this.publisher == null) {
            logger.debug("cannot pause when live");
            return;
        }
        boolean paused = (Boolean)command.getArg(0);
        int clientTimePosition = ((Double)command.getArg(1)).intValue();
        logger.debug("pause request: {}, client time position: {}", (Object)paused, (Object)clientTimePosition);
        if (!paused) {
            logger.debug("doing unpause, seeking and playing");
            Command unpause = Command.unpauseNotify(this.playName, this.clientId);
            this.publisher.start(channel, clientTimePosition, this.getStartMessages(unpause));
        } else {
            this.publisher.pause();
        }
    }

    private void seekResponse(Channel channel, Command command) {
        if (this.publisher == null) {
            logger.debug("cannot seek when live");
            return;
        }
        int clientTimePosition = ((Double)command.getArg(0)).intValue();
        if (!this.publisher.isPaused()) {
            Command seekNotify = Command.seekNotify(this.streamId, clientTimePosition, this.playName, this.clientId);
            this.publisher.start(channel, clientTimePosition, this.getStartMessages(seekNotify));
        } else {
            logger.debug("ignoring seek when paused, client time position: {}", (Object)clientTimePosition);
        }
    }

    private void publishResponse(Channel channel, Command command) {
        if (command.getArgCount() > 1) {
            String streamName = (String)command.getArg(0);
            String publishTypeString = (String)command.getArg(1);
            logger.info("publish, stream name: {}, type: {}", (Object)streamName, (Object)publishTypeString);
            this.subscriberStream = this.application.getStream(streamName, publishTypeString);
            if (this.subscriberStream.getPublisher() != null) {
                logger.info("disconnecting publisher client, stream already in use");
                ChannelFuture future = channel.write((Object)Command.publishBadName(this.streamId));
                future.addListener(ChannelFutureListener.CLOSE);
                return;
            }
            this.subscriberStream.setPublisher(channel);
            channel.write((Object)Command.publishStart(streamName, this.clientId, this.streamId));
            channel.write((Object)new ChunkSize(4096));
            channel.write((Object)Control.streamBegin(this.streamId));
            ServerStream.PublishType publishType = this.subscriberStream.getPublishType();
            logger.info("created publish stream: {}", (Object)this.subscriberStream);
            switch (publishType) {
                case LIVE: {
                    ChannelGroup subscribers = this.subscriberStream.getSubscribers();
                    subscribers.write((Object)Command.publishNotify(this.streamId));
                    this.writeToStream(subscribers, (RtmpMessage)Video.empty());
                    this.writeToStream(subscribers, (RtmpMessage)Metadata.rtmpSampleAccess());
                    this.writeToStream(subscribers, (RtmpMessage)Audio.empty());
                    this.writeToStream(subscribers, (RtmpMessage)Metadata.dataStart());
                    break;
                }
                case RECORD: {
                    this.recorder = this.application.getWriter(streamName);
                    break;
                }
                case APPEND: {
                    logger.warn("append not implemented yet, un-publishing...");
                    this.unpublishIfLive();
                }
            }
        } else {
            boolean publish = (Boolean)command.getArg(0);
            if (!publish) {
                this.unpublishIfLive();
            }
        }
    }

    private void writeToStream(ChannelGroup channelGroup, RtmpMessage message) {
        if (message.getHeader().getChannelId() > 2) {
            message.getHeader().setStreamId(this.streamId);
        }
        channelGroup.write((Object)message);
    }

    private void unpublishIfLive() {
        if (this.subscriberStream != null && this.subscriberStream.getPublisher() != null) {
            Channel channel = this.subscriberStream.getPublisher();
            if (channel.isWritable()) {
                channel.write((Object)Command.unpublishSuccess(this.subscriberStream.getName(), this.clientId, this.streamId));
            }
            this.subscriberStream.getSubscribers().write((Object)Command.unpublishNotify(this.streamId));
            this.subscriberStream.setPublisher(null);
            logger.debug("publisher disconnected, stream un-published");
        }
        if (this.recorder != null) {
            this.recorder.close();
            this.recorder = null;
        }
    }
}

