/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.rtmp.server;

import com.flazr.io.f4v.F4vReader;
import com.flazr.io.flv.FlvReader;
import com.flazr.io.flv.FlvWriter;
import com.flazr.rtmp.RtmpConfig;
import com.flazr.rtmp.RtmpReader;
import com.flazr.rtmp.RtmpWriter;
import com.flazr.rtmp.server.RtmpServer;
import com.flazr.rtmp.server.ServerStream;
import com.flazr.util.Utils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerApplication {
    private static final Logger logger = LoggerFactory.getLogger(ServerApplication.class);
    private final String name;
    private final Map<String, ServerStream> streams;

    public ServerApplication(String rawName) {
        this.name = ServerApplication.cleanName(rawName);
        this.streams = new ConcurrentHashMap<String, ServerStream>();
    }

    public String getName() {
        return this.name;
    }

    public RtmpReader getReader(String rawName) {
        String streamName = Utils.trimSlashes(rawName);
        String path = RtmpConfig.SERVER_HOME_DIR + "/apps/" + this.name + "/";
        try {
            if (streamName.startsWith("mp4:")) {
                String readerPlayName = streamName.substring(4);
                return new F4vReader(path + readerPlayName);
            }
            String readerPlayName = streamName.lastIndexOf(46) < streamName.length() - 4 ? streamName + ".flv" : streamName;
            return new FlvReader(path + readerPlayName);
        }
        catch (Exception e) {
            logger.info("reader creation failed: {}", (Object)e.getMessage());
            return null;
        }
    }

    public RtmpWriter getWriter(String rawName) {
        String streamName = Utils.trimSlashes(rawName);
        String path = RtmpConfig.SERVER_HOME_DIR + "/apps/" + this.name + "/";
        return new FlvWriter(path + streamName + ".flv");
    }

    public static ServerApplication get(String rawName) {
        String appName = ServerApplication.cleanName(rawName);
        ServerApplication app = RtmpServer.APPLICATIONS.get(appName);
        if (app == null) {
            app = new ServerApplication(appName);
            RtmpServer.APPLICATIONS.put(appName, app);
        }
        return app;
    }

    public ServerStream getStream(String rawName) {
        return this.getStream(rawName, null);
    }

    public ServerStream getStream(String rawName, String type) {
        String streamName = ServerApplication.cleanName(rawName);
        ServerStream stream = this.streams.get(streamName);
        if (stream == null) {
            stream = new ServerStream(streamName, type);
            this.streams.put(streamName, stream);
        }
        return stream;
    }

    private static String cleanName(String raw) {
        return Utils.trimSlashes(raw).toLowerCase();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[name: '").append(this.name);
        sb.append("' streams: ").append(this.streams);
        sb.append(']');
        return sb.toString();
    }
}

