/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.rtmp.proxy;

import com.flazr.rtmp.proxy.ProxyHandshakeHandler;
import com.flazr.rtmp.proxy.RtmpProxy;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelPipelineCoverage(value="one")
public class ProxyHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger logger = LoggerFactory.getLogger(ProxyHandler.class);
    private final ClientSocketChannelFactory cf;
    private final String remoteHost;
    private final int remotePort;
    private volatile Channel outboundChannel;

    public ProxyHandler(ClientSocketChannelFactory cf, String remoteHost, int remotePort) {
        this.cf = cf;
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) {
        final Channel inboundChannel = e.getChannel();
        RtmpProxy.ALL_CHANNELS.add((Object)inboundChannel);
        inboundChannel.setReadable(false);
        ClientBootstrap cb = new ClientBootstrap((ChannelFactory)this.cf);
        cb.getPipeline().addLast("handshaker", (ChannelHandler)new ProxyHandshakeHandler());
        cb.getPipeline().addLast("handler", (ChannelHandler)new OutboundHandler(e.getChannel()));
        ChannelFuture f = cb.connect((SocketAddress)new InetSocketAddress(this.remoteHost, this.remotePort));
        this.outboundChannel = f.getChannel();
        f.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    logger.info("connected to remote host: {}, port: {}", (Object)ProxyHandler.this.remoteHost, (Object)ProxyHandler.this.remotePort);
                    inboundChannel.setReadable(true);
                } else {
                    inboundChannel.close();
                }
            }
        });
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        ChannelBuffer in = (ChannelBuffer)e.getMessage();
        this.outboundChannel.write((Object)in);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
        logger.info("closing inbound channel");
        if (this.outboundChannel != null) {
            ProxyHandler.closeOnFlush(this.outboundChannel);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        logger.info("inbound exception: {}", (Object)e.getCause().getMessage());
        ProxyHandler.closeOnFlush(e.getChannel());
    }

    static void closeOnFlush(Channel ch) {
        if (ch.isConnected()) {
            ch.write((Object)ChannelBuffers.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        }
    }

    @ChannelPipelineCoverage(value="one")
    private class OutboundHandler
    extends SimpleChannelUpstreamHandler {
        private final Channel inboundChannel;

        public OutboundHandler(Channel inboundChannel) {
            logger.info("opening outbound channel");
            this.inboundChannel = inboundChannel;
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
            ChannelBuffer in = (ChannelBuffer)e.getMessage();
            this.inboundChannel.write((Object)in);
        }

        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
            logger.info("closing outbound channel");
            ProxyHandler.closeOnFlush(this.inboundChannel);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            logger.info("outbound exception: {}", (Object)e.getCause().getMessage());
            ProxyHandler.closeOnFlush(e.getChannel());
        }
    }
}

