/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.rtmp.message;

import com.flazr.amf.Amf0Object;
import com.flazr.io.f4v.MovieInfo;
import com.flazr.io.f4v.TrackInfo;
import com.flazr.io.f4v.box.STSD;
import com.flazr.rtmp.RtmpHeader;
import com.flazr.rtmp.message.AbstractMessage;
import com.flazr.rtmp.message.Command;
import com.flazr.rtmp.message.MetadataAmf0;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Metadata
extends AbstractMessage {
    protected String name;
    protected Object[] data;

    public Metadata(String name, Object ... data) {
        this.name = name;
        this.data = data;
        this.header.setSize(this.encode().readableBytes());
    }

    public Metadata(RtmpHeader header, ChannelBuffer in) {
        super(header, in);
    }

    public Object getData(int index) {
        if (this.data == null || this.data.length < index + 1) {
            return null;
        }
        return this.data[index];
    }

    private Object getValue(String key) {
        Map<String, Object> map = this.getMap(0);
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public void setValue(String key, Object value) {
        if (this.data == null || this.data.length == 0) {
            this.data = new Object[]{new LinkedHashMap()};
        }
        if (this.data[0] == null) {
            this.data[0] = new LinkedHashMap();
        }
        Map map = (Map)this.data[0];
        map.put(key, value);
    }

    public Map<String, Object> getMap(int index) {
        return (Map)this.getData(index);
    }

    public String getString(String key) {
        return (String)this.getValue(key);
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.getValue(key);
    }

    public Double getDouble(String key) {
        return (Double)this.getValue(key);
    }

    public double getDuration() {
        if (this.data == null || this.data.length == 0) {
            return -1.0;
        }
        Map<String, Object> map = this.getMap(0);
        if (map == null) {
            return -1.0;
        }
        Object o = map.get("duration");
        if (o == null) {
            return -1.0;
        }
        return ((Double)o).longValue();
    }

    public void setDuration(double duration) {
        Object meta;
        Map map;
        if (this.data == null || this.data.length == 0) {
            this.data = new Object[]{Metadata.map(Metadata.pair("duration", duration))};
        }
        if ((map = (Map)(meta = this.data[0])) == null) {
            this.data[0] = Metadata.map(Metadata.pair("duration", duration));
            return;
        }
        map.put("duration", duration);
    }

    public static Metadata onPlayStatus(double duration, double bytes) {
        Amf0Object map = Command.onStatus(Command.OnStatus.STATUS, "NetStream.Play.Complete", Metadata.pair("duration", duration), Metadata.pair("bytes", bytes));
        return new MetadataAmf0("onPlayStatus", map);
    }

    public static Metadata rtmpSampleAccess() {
        return new MetadataAmf0("|RtmpSampleAccess", false, false);
    }

    public static Metadata dataStart() {
        return new MetadataAmf0("onStatus", Metadata.object(Metadata.pair("code", "NetStream.Data.Start")));
    }

    public static Metadata onMetaDataTest(MovieInfo movie) {
        Amf0Object track1 = Metadata.object(Metadata.pair("length", 3369366.0), Metadata.pair("timescale", 30000.0), Metadata.pair("language", "eng"), Metadata.pair("sampledescription", new Amf0Object[]{Metadata.object(Metadata.pair("sampletype", "avc1"))}));
        Amf0Object track2 = Metadata.object(Metadata.pair("length", 2697216.0), Metadata.pair("timescale", 24000.0), Metadata.pair("language", "eng"), Metadata.pair("sampledescription", new Amf0Object[]{Metadata.object(Metadata.pair("sampletype", "mp4a"))}));
        Map<String, Object> map = Metadata.map(Metadata.pair("duration", movie.getDuration()), Metadata.pair("moovPosition", movie.getMoovPosition()), Metadata.pair("width", 640.0), Metadata.pair("height", 352.0), Metadata.pair("videocodecid", "avc1"), Metadata.pair("audiocodecid", "mp4a"), Metadata.pair("avcprofile", 100.0), Metadata.pair("avclevel", 30.0), Metadata.pair("aacaot", 2.0), Metadata.pair("videoframerate", 29.97002997002997), Metadata.pair("audiosamplerate", 24000.0), Metadata.pair("audiochannels", 2.0), Metadata.pair("trackinfo", new Amf0Object[]{track1, track2}));
        return new MetadataAmf0("onMetaData", map);
    }

    public static Metadata onMetaData(MovieInfo movie) {
        Map<String, Object> map = Metadata.map(Metadata.pair("duration", movie.getDuration()), Metadata.pair("moovPosition", movie.getMoovPosition()));
        TrackInfo track1 = movie.getVideoTrack();
        Amf0Object t1 = null;
        if (track1 != null) {
            String sampleType = track1.getStsd().getSampleTypeString(1);
            t1 = Metadata.object(Metadata.pair("length", track1.getMdhd().getDuration()), Metadata.pair("timescale", track1.getMdhd().getTimeScale()), Metadata.pair("sampledescription", new Amf0Object[]{Metadata.object(Metadata.pair("sampletype", sampleType))}));
            STSD.VideoSD video = movie.getVideoSampleDescription();
            Metadata.map(map, Metadata.pair("width", video.getWidth()), Metadata.pair("height", video.getHeight()), Metadata.pair("videocodecid", sampleType));
        }
        TrackInfo track2 = movie.getAudioTrack();
        Amf0Object t2 = null;
        if (track2 != null) {
            String sampleType = track2.getStsd().getSampleTypeString(1);
            t2 = Metadata.object(Metadata.pair("length", track2.getMdhd().getDuration()), Metadata.pair("timescale", track2.getMdhd().getTimeScale()), Metadata.pair("sampledescription", new Amf0Object[]{Metadata.object(Metadata.pair("sampletype", sampleType))}));
            Metadata.map(map, Metadata.pair("audiocodecid", sampleType));
        }
        ArrayList<Amf0Object> trackList = new ArrayList<Amf0Object>();
        if (t1 != null) {
            trackList.add(t1);
        }
        if (t2 != null) {
            trackList.add(t2);
        }
        Metadata.map(map, Metadata.pair("trackinfo", trackList.toArray()));
        return new MetadataAmf0("onMetaData", map);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("name: ").append(this.name);
        sb.append(" data: ").append(Arrays.toString(this.data));
        return sb.toString();
    }
}

