/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.rtmp.message;

import com.flazr.amf.Amf0Object;
import com.flazr.rtmp.RtmpHeader;
import com.flazr.rtmp.client.ClientOptions;
import com.flazr.rtmp.message.AbstractMessage;
import com.flazr.rtmp.message.CommandAmf0;
import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;

public abstract class Command
extends AbstractMessage {
    protected String name;
    protected int transactionId;
    protected Amf0Object object;
    protected Object[] args;

    public Command(RtmpHeader header, ChannelBuffer in) {
        super(header, in);
    }

    public Command(int transactionId, String name, Amf0Object object, Object ... args) {
        this.transactionId = transactionId;
        this.name = name;
        this.object = object;
        this.args = args;
    }

    public Command(String name, Amf0Object object, Object ... args) {
        this(0, name, object, args);
    }

    public Amf0Object getObject() {
        return this.object;
    }

    public Object getArg(int index) {
        return this.args[index];
    }

    public int getArgCount() {
        if (this.args == null) {
            return 0;
        }
        return this.args.length;
    }

    private static Amf0Object onStatus(OnStatus level, String code, String description, String details, AbstractMessage.Pair ... pairs) {
        Amf0Object object = Command.object(Command.pair("level", level.asString()), Command.pair("code", code));
        if (description != null) {
            object.put("description", description);
        }
        if (details != null) {
            object.put("details", details);
        }
        return Command.object(object, pairs);
    }

    private static Amf0Object onStatus(OnStatus level, String code, String description, AbstractMessage.Pair ... pairs) {
        return Command.onStatus(level, code, description, null, pairs);
    }

    public static Amf0Object onStatus(OnStatus level, String code, AbstractMessage.Pair ... pairs) {
        return Command.onStatus(level, code, null, null, pairs);
    }

    public static Command connect(ClientOptions options) {
        Amf0Object object = Command.object(Command.pair("app", options.getAppName()), Command.pair("flashVer", "WIN 9,0,124,2"), Command.pair("tcUrl", options.getTcUrl()), Command.pair("fpad", false), Command.pair("audioCodecs", 1639.0), Command.pair("videoCodecs", 252.0), Command.pair("objectEncoding", 0.0), Command.pair("capabilities", 15.0), Command.pair("videoFunction", 1.0));
        if (options.getParams() != null) {
            object.putAll(options.getParams());
        }
        return new CommandAmf0("connect", object, options.getArgs());
    }

    public static Command connectSuccess(int transactionId) {
        Amf0Object object = Command.onStatus(OnStatus.STATUS, "NetConnection.Connect.Success", "Connection succeeded.", Command.pair("fmsVer", "FMS/3,5,1,516"), Command.pair("capabilities", 31.0), Command.pair("mode", 1.0), Command.pair("objectEncoding", 0.0));
        return new CommandAmf0(transactionId, "_result", null, object);
    }

    public static Command createStream() {
        return new CommandAmf0("createStream", null, new Object[0]);
    }

    public static Command onBWDone() {
        return new CommandAmf0("onBWDone", null, new Object[0]);
    }

    public static Command createStreamSuccess(int transactionId, int streamId) {
        return new CommandAmf0(transactionId, "_result", null, streamId);
    }

    public static Command play(int streamId, ClientOptions options) {
        ArrayList<Object> playArgs = new ArrayList<Object>();
        playArgs.add(options.getStreamName());
        if (options.getStart() != -2 || options.getArgs() != null) {
            playArgs.add(options.getStart());
        }
        if (options.getLength() != -1 || options.getArgs() != null) {
            playArgs.add(options.getLength());
        }
        if (options.getArgs() != null) {
            playArgs.addAll(Arrays.asList(options.getArgs()));
        }
        CommandAmf0 command = new CommandAmf0("play", null, playArgs.toArray());
        command.header.setChannelId(8);
        command.header.setStreamId(streamId);
        return command;
    }

    private static Command playStatus(String code, String description, String playName, String clientId, AbstractMessage.Pair ... pairs) {
        Amf0Object status = Command.onStatus(OnStatus.STATUS, "NetStream.Play." + code, description + " " + playName + ".", Command.pair("details", playName), Command.pair("clientid", clientId));
        Command.object(status, pairs);
        CommandAmf0 command = new CommandAmf0("onStatus", null, status);
        command.header.setChannelId(5);
        return command;
    }

    public static Command playReset(String playName, String clientId) {
        Command command = Command.playStatus("Reset", "Playing and resetting", playName, clientId, new AbstractMessage.Pair[0]);
        command.header.setChannelId(4);
        return command;
    }

    public static Command playStart(String playName, String clientId) {
        Command play = Command.playStatus("Start", "Started playing", playName, clientId, new AbstractMessage.Pair[0]);
        return play;
    }

    public static Command playStop(String playName, String clientId) {
        return Command.playStatus("Stop", "Stopped playing", playName, clientId, new AbstractMessage.Pair[0]);
    }

    public static Command playFailed(String playName, String clientId) {
        Amf0Object status = Command.onStatus(OnStatus.ERROR, "NetStream.Play.Failed", "Stream not found", new AbstractMessage.Pair[0]);
        CommandAmf0 command = new CommandAmf0("onStatus", null, status);
        command.header.setChannelId(8);
        return command;
    }

    public static Command seekNotify(int streamId, int seekTime, String playName, String clientId) {
        Amf0Object status = Command.onStatus(OnStatus.STATUS, "NetStream.Seek.Notify", "Seeking " + seekTime + " (stream ID: " + streamId + ").", Command.pair("details", playName), Command.pair("clientid", clientId));
        CommandAmf0 command = new CommandAmf0("onStatus", null, status);
        command.header.setChannelId(5);
        command.header.setStreamId(streamId);
        command.header.setTime(seekTime);
        return command;
    }

    public static Command pauseNotify(String playName, String clientId) {
        Amf0Object status = Command.onStatus(OnStatus.STATUS, "NetStream.Pause.Notify", "Pausing " + playName, Command.pair("details", playName), Command.pair("clientid", clientId));
        CommandAmf0 command = new CommandAmf0("onStatus", null, status);
        command.header.setChannelId(5);
        return command;
    }

    public static Command unpauseNotify(String playName, String clientId) {
        Amf0Object status = Command.onStatus(OnStatus.STATUS, "NetStream.Unpause.Notify", "Unpausing " + playName, Command.pair("details", playName), Command.pair("clientid", clientId));
        CommandAmf0 command = new CommandAmf0("onStatus", null, status);
        command.header.setChannelId(5);
        return command;
    }

    public static Command publish(int streamId, ClientOptions options) {
        CommandAmf0 command = new CommandAmf0("publish", null, options.getStreamName(), options.getPublishType().asString());
        command.header.setChannelId(8);
        command.header.setStreamId(streamId);
        return command;
    }

    private static Command publishStatus(String code, String streamName, String clientId, AbstractMessage.Pair ... pairs) {
        Amf0Object status = Command.onStatus(OnStatus.STATUS, code, null, streamName, Command.pair("details", streamName), Command.pair("clientid", clientId));
        Command.object(status, pairs);
        CommandAmf0 command = new CommandAmf0("onStatus", null, status);
        command.header.setChannelId(8);
        return command;
    }

    public static Command publishStart(String streamName, String clientId, int streamId) {
        return Command.publishStatus("NetStream.Publish.Start", streamName, clientId, new AbstractMessage.Pair[0]);
    }

    public static Command unpublishSuccess(String streamName, String clientId, int streamId) {
        return Command.publishStatus("NetStream.Unpublish.Success", streamName, clientId, new AbstractMessage.Pair[0]);
    }

    public static Command unpublish(int streamId) {
        CommandAmf0 command = new CommandAmf0("publish", null, false);
        command.header.setChannelId(8);
        command.header.setStreamId(streamId);
        return command;
    }

    public static Command publishBadName(int streamId) {
        CommandAmf0 command = new CommandAmf0("onStatus", null, Command.onStatus(OnStatus.ERROR, "NetStream.Publish.BadName", "Stream already exists.", new AbstractMessage.Pair[0]));
        command.header.setChannelId(8);
        command.header.setStreamId(streamId);
        return command;
    }

    public static Command publishNotify(int streamId) {
        CommandAmf0 command = new CommandAmf0("onStatus", null, Command.onStatus(OnStatus.STATUS, "NetStream.Play.PublishNotify", new AbstractMessage.Pair[0]));
        command.header.setChannelId(8);
        command.header.setStreamId(streamId);
        return command;
    }

    public static Command unpublishNotify(int streamId) {
        CommandAmf0 command = new CommandAmf0("onStatus", null, Command.onStatus(OnStatus.STATUS, "NetStream.Play.UnpublishNotify", new AbstractMessage.Pair[0]));
        command.header.setChannelId(8);
        command.header.setStreamId(streamId);
        return command;
    }

    public static Command closeStream(int streamId) {
        CommandAmf0 command = new CommandAmf0("closeStream", null, new Object[0]);
        command.header.setChannelId(8);
        command.header.setStreamId(streamId);
        return command;
    }

    public String getName() {
        return this.name;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(int transactionId) {
        this.transactionId = transactionId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("name: ").append(this.name);
        sb.append(", transactionId: ").append(this.transactionId);
        sb.append(", object: ").append(this.object);
        sb.append(", args: ").append(Arrays.toString(this.args));
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OnStatus {
        ERROR,
        STATUS,
        WARNING;


        public static OnStatus parse(String raw) {
            return OnStatus.valueOf(raw.substring(1).toUpperCase());
        }

        public String asString() {
            return "_" + this.name().toLowerCase();
        }
    }
}

