/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.rtmp.client;

import com.flazr.rtmp.client.ClientOptions;
import com.flazr.rtmp.client.ClientPipelineFactory;
import com.flazr.util.Utils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtmpClient {
    private static final Logger logger = LoggerFactory.getLogger(RtmpClient.class);

    public static void main(String[] args) {
        System.out.println();
        final ClientOptions options = new ClientOptions();
        if (!options.parseCli(args)) {
            return;
        }
        Utils.printlnCopyrightNotice();
        int count = options.getLoad();
        if (count == 1 && options.getClientOptionsList() == null) {
            RtmpClient.connect(options);
            return;
        }
        final ExecutorService executor = Executors.newFixedThreadPool(options.getThreads());
        if (options.getClientOptionsList() != null) {
            logger.info("file driven load testing mode, lines: {}", (Object)options.getClientOptionsList().size());
            int line = 0;
            for (final ClientOptions tempOptions : options.getClientOptionsList()) {
                logger.info("running line #{}", (Object)(++line));
                for (int i = 0; i < tempOptions.getLoad(); ++i) {
                    final int index = i + 1;
                    final int tempLine = line;
                    executor.execute(new Runnable(){

                        public void run() {
                            ClientBootstrap bootstrap = RtmpClient.getBootstrap(executor, tempOptions);
                            bootstrap.connect((SocketAddress)new InetSocketAddress(tempOptions.getHost(), tempOptions.getPort()));
                            logger.info("line #{}, spawned connection #{}", (Object)(tempLine + 1), (Object)index);
                        }
                    });
                }
            }
            return;
        }
        final ClientBootstrap bootstrap = RtmpClient.getBootstrap(executor, options);
        logger.info("load testing mode, no. of connections to create: {}", (Object)count);
        options.setSaveAs(null);
        for (int i = 0; i < count; ++i) {
            final int index = i + 1;
            executor.execute(new Runnable(){

                public void run() {
                    bootstrap.connect((SocketAddress)new InetSocketAddress(options.getHost(), options.getPort()));
                    logger.info("spawned connection #{}", (Object)index);
                }
            });
        }
    }

    public static void connect(ClientOptions options) {
        ClientBootstrap bootstrap = RtmpClient.getBootstrap(Executors.newCachedThreadPool(), options);
        ChannelFuture future = bootstrap.connect((SocketAddress)new InetSocketAddress(options.getHost(), options.getPort()));
        future.awaitUninterruptibly();
        if (!future.isSuccess()) {
            logger.error("error creating client connection: {}", (Object)future.getCause().getMessage());
        }
        future.getChannel().getCloseFuture().awaitUninterruptibly();
        bootstrap.getFactory().releaseExternalResources();
    }

    private static ClientBootstrap getBootstrap(Executor executor, ClientOptions options) {
        NioClientSocketChannelFactory factory = new NioClientSocketChannelFactory(executor, executor);
        ClientBootstrap bootstrap = new ClientBootstrap((ChannelFactory)factory);
        bootstrap.setPipelineFactory((ChannelPipelineFactory)new ClientPipelineFactory(options));
        bootstrap.setOption("tcpNoDelay", (Object)true);
        bootstrap.setOption("keepAlive", (Object)true);
        return bootstrap;
    }
}

