/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.rtmp.client;

import com.flazr.rtmp.RtmpHandshake;
import com.flazr.rtmp.RtmpPublisher;
import com.flazr.rtmp.client.ClientHandler;
import com.flazr.rtmp.client.ClientOptions;
import java.net.SocketAddress;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHandshakeHandler
extends FrameDecoder
implements ChannelDownstreamHandler {
    private static final Logger logger = LoggerFactory.getLogger(ClientHandshakeHandler.class);
    private boolean rtmpe;
    private final RtmpHandshake handshake;
    private boolean handshakeDone;

    public ClientHandshakeHandler(ClientOptions options) {
        this.handshake = new RtmpHandshake(options);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        logger.info("connected, starting handshake");
        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)e.getFuture(), (Object)this.handshake.encodeClient0());
        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)e.getFuture(), (Object)this.handshake.encodeClient1());
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer in) {
        if (in.readableBytes() < 3073) {
            return null;
        }
        this.handshake.decodeServerAll(in);
        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)Channels.succeededFuture((Channel)channel), (Object)this.handshake.encodeClient2());
        this.handshakeDone = true;
        this.rtmpe = this.handshake.isRtmpe();
        if (this.handshake.getSwfvBytes() != null) {
            ClientHandler clientHandler = (ClientHandler)channel.getPipeline().get(ClientHandler.class);
            clientHandler.setSwfvBytes(this.handshake.getSwfvBytes());
        }
        if (!this.rtmpe) {
            channel.getPipeline().remove((ChannelHandler)this);
        }
        Channels.fireChannelConnected((ChannelHandlerContext)ctx, (SocketAddress)channel.getRemoteAddress());
        return in;
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent ce) throws Exception {
        if (!(this.handshakeDone && this.rtmpe && ce instanceof MessageEvent)) {
            super.handleUpstream(ctx, ce);
            return;
        }
        MessageEvent me = (MessageEvent)ce;
        if (me.getMessage() instanceof RtmpPublisher.Event) {
            super.handleUpstream(ctx, ce);
            return;
        }
        ChannelBuffer in = (ChannelBuffer)((MessageEvent)ce).getMessage();
        this.handshake.cipherUpdateIn(in);
        Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)in);
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent ce) {
        if (!(this.handshakeDone && this.rtmpe && ce instanceof MessageEvent)) {
            ctx.sendDownstream(ce);
            return;
        }
        ChannelBuffer in = (ChannelBuffer)((MessageEvent)ce).getMessage();
        this.handshake.cipherUpdateOut(in);
        ctx.sendDownstream(ce);
    }
}

