/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.rtmp;

import com.flazr.rtmp.message.MessageType;
import com.flazr.util.Utils;
import com.flazr.util.ValueToEnum;
import org.jboss.netty.buffer.ChannelBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtmpHeader {
    private static final Logger logger = LoggerFactory.getLogger(RtmpHeader.class);
    public static final int MAX_CHANNEL_ID = 65600;
    public static final int MAX_NORMAL_HEADER_TIME = 0xFFFFFF;
    public static final int MAX_ENCODED_SIZE = 18;
    private Type headerType;
    private int channelId;
    private int deltaTime;
    private int time;
    private int size;
    private MessageType messageType;
    private int streamId;

    public RtmpHeader(ChannelBuffer in, RtmpHeader[] incompleteHeaders) {
        int headerTypeInt;
        byte firstByteInt = in.readByte();
        if ((firstByteInt & 0x3F) == 0) {
            int typeAndChannel = (firstByteInt & 0xFF) << 8 | in.readByte() & 0xFF;
            this.channelId = 64 + (typeAndChannel & 0xFF);
            headerTypeInt = typeAndChannel >> 14;
        } else if ((firstByteInt & 0x3F) == 1) {
            int typeAndChannel = (firstByteInt & 0xFF) << 16 | (in.readByte() & 0xFF) << 8 | in.readByte() & 0xFF;
            this.channelId = 64 + (typeAndChannel >> 8 & 0xFF) + ((typeAndChannel & 0xFF) << 8);
            headerTypeInt = typeAndChannel >> 22;
        } else {
            int typeAndChannel = firstByteInt & 0xFF;
            this.channelId = typeAndChannel & 0x3F;
            headerTypeInt = typeAndChannel >> 6;
        }
        this.headerType = Type.valueToEnum(headerTypeInt);
        RtmpHeader prevHeader = incompleteHeaders[this.channelId];
        switch (this.headerType) {
            case LARGE: {
                this.time = in.readMedium();
                this.size = in.readMedium();
                this.messageType = MessageType.valueToEnum(in.readByte());
                this.streamId = Utils.readInt32Reverse(in);
                if (this.time != 0xFFFFFF) break;
                this.time = in.readInt();
                break;
            }
            case MEDIUM: {
                this.deltaTime = in.readMedium();
                this.size = in.readMedium();
                this.messageType = MessageType.valueToEnum(in.readByte());
                this.streamId = prevHeader.streamId;
                if (this.deltaTime != 0xFFFFFF) break;
                this.deltaTime = in.readInt();
                break;
            }
            case SMALL: {
                this.deltaTime = in.readMedium();
                this.size = prevHeader.size;
                this.messageType = prevHeader.messageType;
                this.streamId = prevHeader.streamId;
                if (this.deltaTime != 0xFFFFFF) break;
                this.deltaTime = in.readInt();
                break;
            }
            case TINY: {
                this.headerType = prevHeader.headerType;
                this.time = prevHeader.time;
                this.deltaTime = prevHeader.deltaTime;
                this.size = prevHeader.size;
                this.messageType = prevHeader.messageType;
                this.streamId = prevHeader.streamId;
            }
        }
    }

    public RtmpHeader(MessageType messageType, int time, int size) {
        this(messageType);
        this.time = time;
        this.size = size;
    }

    public RtmpHeader(MessageType messageType) {
        this.messageType = messageType;
        this.headerType = Type.LARGE;
        this.channelId = messageType.getDefaultChannelId();
    }

    public boolean isMedia() {
        switch (this.messageType) {
            case AUDIO: 
            case VIDEO: 
            case AGGREGATE: {
                return true;
            }
        }
        return false;
    }

    public boolean isMetadata() {
        return this.messageType == MessageType.METADATA_AMF0 || this.messageType == MessageType.METADATA_AMF3;
    }

    public boolean isAggregate() {
        return this.messageType == MessageType.AGGREGATE;
    }

    public boolean isAudio() {
        return this.messageType == MessageType.AUDIO;
    }

    public boolean isVideo() {
        return this.messageType == MessageType.VIDEO;
    }

    public boolean isLarge() {
        return this.headerType == Type.LARGE;
    }

    public boolean isControl() {
        return this.messageType == MessageType.CONTROL;
    }

    public boolean isChunkSize() {
        return this.messageType == MessageType.CHUNK_SIZE;
    }

    public Type getHeaderType() {
        return this.headerType;
    }

    public void setHeaderType(Type headerType) {
        this.headerType = headerType;
    }

    public int getChannelId() {
        return this.channelId;
    }

    public void setChannelId(int channelId) {
        this.channelId = channelId;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public int getDeltaTime() {
        return this.deltaTime;
    }

    public void setDeltaTime(int deltaTime) {
        this.deltaTime = deltaTime;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public void setStreamId(int streamId) {
        this.streamId = streamId;
    }

    public void encode(ChannelBuffer out) {
        boolean extendedTime;
        out.writeBytes(RtmpHeader.encodeHeaderTypeAndChannel(this.headerType.value, this.channelId));
        if (this.headerType == Type.TINY) {
            return;
        }
        if (this.headerType == Type.LARGE) {
            extendedTime = this.time >= 0xFFFFFF;
        } else {
            boolean bl = extendedTime = this.deltaTime >= 0xFFFFFF;
        }
        if (extendedTime) {
            out.writeMedium(0xFFFFFF);
        } else {
            out.writeMedium(this.headerType == Type.LARGE ? this.time : this.deltaTime);
        }
        if (this.headerType != Type.SMALL) {
            out.writeMedium(this.size);
            out.writeByte((byte)this.messageType.intValue());
            if (this.headerType == Type.LARGE) {
                Utils.writeInt32Reverse(out, this.streamId);
            }
        }
        if (extendedTime) {
            out.writeInt(this.headerType == Type.LARGE ? this.time : this.deltaTime);
        }
    }

    public byte[] getTinyHeader() {
        return RtmpHeader.encodeHeaderTypeAndChannel(Type.TINY.intValue(), this.channelId);
    }

    private static byte[] encodeHeaderTypeAndChannel(int headerType, int channelId) {
        if (channelId <= 63) {
            return new byte[]{(byte)((headerType << 6) + channelId)};
        }
        if (channelId <= 320) {
            return new byte[]{(byte)(headerType << 6), (byte)(channelId - 64)};
        }
        return new byte[]{(byte)(headerType << 6 | 1), (byte)(channelId - 64 & 0xFF), (byte)(channelId - 64 >> 8)};
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.headerType.ordinal());
        sb.append(' ').append(this.messageType);
        sb.append(" c").append(this.channelId);
        sb.append(" #").append(this.streamId);
        sb.append(" t").append(this.time);
        sb.append(" (").append(this.deltaTime);
        sb.append(") s").append(this.size);
        sb.append(']');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type implements ValueToEnum.IntValue
    {
        LARGE(0),
        MEDIUM(1),
        SMALL(2),
        TINY(3);

        private final int value;
        private static final ValueToEnum<Type> converter;

        private Type(int value) {
            this.value = value;
        }

        @Override
        public int intValue() {
            return this.value;
        }

        public static Type valueToEnum(int value) {
            return converter.valueToEnum(value);
        }

        static {
            converter = new ValueToEnum((Enum[])Type.values());
        }
    }
}

