/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.rtmp;

import com.flazr.rtmp.client.ClientOptions;
import com.flazr.util.Utils;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtmpHandshake {
    private static final Logger logger = LoggerFactory.getLogger(RtmpHandshake.class);
    public static final int HANDSHAKE_SIZE = 1536;
    private static final int DIGEST_SIZE = 32;
    private static final int PUBLIC_KEY_SIZE = 128;
    private static final byte[] SERVER_CONST = "Genuine Adobe Flash Media Server 001".getBytes();
    public static final byte[] CLIENT_CONST = "Genuine Adobe Flash Player 001".getBytes();
    private static final byte[] RANDOM_CRUD = Utils.fromHex("F0EEC24A8068BEE82E00D0D1029E7E576EEC5D2D29806FAB93B8E636CFEB31AE");
    private static final byte[] SERVER_CONST_CRUD = RtmpHandshake.concat(SERVER_CONST, RANDOM_CRUD);
    private static final byte[] CLIENT_CONST_CRUD = RtmpHandshake.concat(CLIENT_CONST, RANDOM_CRUD);
    private static final byte[] DH_MODULUS_BYTES = Utils.fromHex("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE65381FFFFFFFFFFFFFFFF");
    private static final BigInteger DH_MODULUS = new BigInteger(1, DH_MODULUS_BYTES);
    private static final BigInteger DH_BASE = BigInteger.valueOf(2L);
    private static final Map<Integer, Integer> clientVersionToValidationTypeMap;
    private byte[] clientVersionToUse = new byte[]{9, 0, 124, 2};
    private byte[] serverVersionToUse = new byte[]{3, 5, 1, 1};
    private KeyAgreement keyAgreement;
    private byte[] peerVersion;
    private byte[] ownPublicKey;
    private byte[] peerPublicKey;
    private byte[] ownPartOneDigest;
    private byte[] peerPartOneDigest;
    private Cipher cipherOut;
    private Cipher cipherIn;
    private byte[] peerTime;
    private boolean rtmpe;
    private int validationType;
    private byte[] swfHash;
    private int swfSize;
    private byte[] swfvBytes;
    private ChannelBuffer peerPartOne;
    private ChannelBuffer ownPartOne;

    private static byte[] concat(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    private static int calculateOffset(ChannelBuffer in, int pointerIndex, int modulus, int increment) {
        byte[] pointer = new byte[4];
        in.getBytes(pointerIndex, pointer);
        int offset = 0;
        for (int i = 0; i < pointer.length; ++i) {
            offset += pointer[i] & 0xFF;
        }
        offset %= modulus;
        return offset += increment;
    }

    private static byte[] digestHandshake(ChannelBuffer in, int digestOffset, byte[] key) {
        byte[] message = new byte[1504];
        in.getBytes(0, message, 0, digestOffset);
        int afterDigestOffset = digestOffset + 32;
        in.getBytes(afterDigestOffset, message, digestOffset, 1536 - afterDigestOffset);
        return Utils.sha256(message, key);
    }

    private static ChannelBuffer generateRandomHandshake() {
        byte[] randomBytes = new byte[1536];
        Random random = new Random();
        random.nextBytes(randomBytes);
        return ChannelBuffers.wrappedBuffer((byte[])randomBytes);
    }

    protected static int getValidationTypeForClientVersion(byte[] version) {
        int intValue = ChannelBuffers.wrappedBuffer((byte[])version).getInt(0);
        Integer type = clientVersionToValidationTypeMap.get(intValue);
        if (type == null) {
            return 0;
        }
        return type;
    }

    private static int digestOffset(ChannelBuffer in, int validationType) {
        switch (validationType) {
            case 1: {
                return RtmpHandshake.calculateOffset(in, 8, 728, 12);
            }
            case 2: {
                return RtmpHandshake.calculateOffset(in, 772, 728, 776);
            }
        }
        throw new RuntimeException("cannot get digest offset for type: " + validationType);
    }

    private static int publicKeyOffset(ChannelBuffer in, int validationType) {
        switch (validationType) {
            case 1: {
                return RtmpHandshake.calculateOffset(in, 1532, 632, 772);
            }
            case 2: {
                return RtmpHandshake.calculateOffset(in, 768, 632, 8);
            }
        }
        throw new RuntimeException("cannot get public key offset for type: " + validationType);
    }

    public RtmpHandshake() {
    }

    public RtmpHandshake(ClientOptions session) {
        this.rtmpe = session.isRtmpe();
        this.swfHash = session.getSwfHash();
        this.swfSize = session.getSwfSize();
        if (session.getClientVersionToUse() != null) {
            this.clientVersionToUse = session.getClientVersionToUse();
        }
    }

    public byte[] getSwfvBytes() {
        return this.swfvBytes;
    }

    public Cipher getCipherIn() {
        return this.cipherIn;
    }

    public Cipher getCipherOut() {
        return this.cipherOut;
    }

    public boolean isRtmpe() {
        return this.rtmpe;
    }

    public byte[] getPeerVersion() {
        return this.peerVersion;
    }

    private void cipherUpdate(ChannelBuffer in, Cipher cipher) {
        int size = in.readableBytes();
        if (size == 0) {
            return;
        }
        int position = in.readerIndex();
        byte[] bytes = new byte[size];
        in.getBytes(position, bytes);
        in.setBytes(position, cipher.update(bytes));
    }

    public void cipherUpdateIn(ChannelBuffer in) {
        this.cipherUpdate(in, this.cipherIn);
    }

    public void cipherUpdateOut(ChannelBuffer in) {
        this.cipherUpdate(in, this.cipherOut);
    }

    private void initKeyPair() {
        KeyPair keyPair;
        DHParameterSpec keySpec = new DHParameterSpec(DH_MODULUS, DH_BASE);
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("DH");
            keyGen.initialize(keySpec);
            keyPair = keyGen.generateKeyPair();
            this.keyAgreement = KeyAgreement.getInstance("DH");
            this.keyAgreement.init(keyPair.getPrivate());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        DHPublicKey publicKey = (DHPublicKey)keyPair.getPublic();
        BigInteger dh_Y = publicKey.getY();
        this.ownPublicKey = dh_Y.toByteArray();
        byte[] temp = new byte[128];
        if (this.ownPublicKey.length < 128) {
            System.arraycopy(this.ownPublicKey, 0, temp, 128 - this.ownPublicKey.length, this.ownPublicKey.length);
            this.ownPublicKey = temp;
        } else if (this.ownPublicKey.length > 128) {
            System.arraycopy(this.ownPublicKey, this.ownPublicKey.length - 128, temp, 0, 128);
            this.ownPublicKey = temp;
        }
    }

    private void initCiphers() {
        BigInteger otherPublicKeyInt = new BigInteger(1, this.peerPublicKey);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DH");
            DHPublicKeySpec otherPublicKeySpec = new DHPublicKeySpec(otherPublicKeyInt, DH_MODULUS, DH_BASE);
            PublicKey otherPublicKey = keyFactory.generatePublic(otherPublicKeySpec);
            this.keyAgreement.doPhase(otherPublicKey, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] sharedSecret = this.keyAgreement.generateSecret();
        byte[] digestOut = Utils.sha256(this.peerPublicKey, sharedSecret);
        byte[] digestIn = Utils.sha256(this.ownPublicKey, sharedSecret);
        try {
            this.cipherOut = Cipher.getInstance("RC4");
            this.cipherOut.init(1, new SecretKeySpec(digestOut, 0, 16, "RC4"));
            this.cipherIn = Cipher.getInstance("RC4");
            this.cipherIn.init(2, new SecretKeySpec(digestIn, 0, 16, "RC4"));
            logger.info("initialized encryption / decryption ciphers");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] dummyBytes = new byte[1536];
        this.cipherIn.update(dummyBytes);
        this.cipherOut.update(dummyBytes);
    }

    public ChannelBuffer encodeClient0() {
        ChannelBuffer out = ChannelBuffers.buffer((int)1);
        if (this.rtmpe) {
            out.writeByte((byte)6);
        } else {
            out.writeByte((byte)3);
        }
        return out;
    }

    public ChannelBuffer encodeClient1() {
        ChannelBuffer out = RtmpHandshake.generateRandomHandshake();
        out.setInt(0, 0);
        out.setBytes(4, this.clientVersionToUse);
        this.validationType = RtmpHandshake.getValidationTypeForClientVersion(this.clientVersionToUse);
        logger.info("using client version {}", (Object)Utils.toHex(this.clientVersionToUse));
        if (this.validationType == 0) {
            this.ownPartOne = out.copy();
            return out;
        }
        logger.debug("creating client part 1, validation type: {}", (Object)this.validationType);
        this.initKeyPair();
        int publicKeyOffset = RtmpHandshake.publicKeyOffset(out, this.validationType);
        out.setBytes(publicKeyOffset, this.ownPublicKey);
        int digestOffset = RtmpHandshake.digestOffset(out, this.validationType);
        this.ownPartOneDigest = RtmpHandshake.digestHandshake(out, digestOffset, CLIENT_CONST);
        out.setBytes(digestOffset, this.ownPartOneDigest);
        return out;
    }

    public boolean decodeServerAll(ChannelBuffer in) {
        this.decodeServer0(in.readBytes(1));
        this.decodeServer1(in.readBytes(1536));
        this.decodeServer2(in.readBytes(1536));
        return true;
    }

    private void decodeServer0(ChannelBuffer in) {
        byte flag = in.getByte(0);
        if (this.rtmpe && flag != 6) {
            logger.warn("server does not support rtmpe! falling back to rtmp");
            this.rtmpe = false;
        }
    }

    private void decodeServer1(ChannelBuffer in) {
        this.peerTime = new byte[4];
        in.getBytes(0, this.peerTime);
        byte[] serverVersion = new byte[4];
        in.getBytes(4, serverVersion);
        logger.debug("server time: {}, version: {}", (Object)Utils.toHex(this.peerTime), (Object)Utils.toHex(serverVersion));
        if (this.swfHash != null) {
            byte[] key = new byte[32];
            in.getBytes(1504, key);
            byte[] digest = Utils.sha256(this.swfHash, key);
            ChannelBuffer swfv = ChannelBuffers.buffer((int)42);
            swfv.writeByte((byte)1);
            swfv.writeByte((byte)1);
            swfv.writeInt(this.swfSize);
            swfv.writeInt(this.swfSize);
            swfv.writeBytes(digest);
            this.swfvBytes = new byte[42];
            swfv.readBytes(this.swfvBytes);
            logger.info("calculated swf verification response: {}", (Object)Utils.toHex(this.swfvBytes));
        }
        if (this.validationType == 0) {
            this.peerPartOne = in;
            return;
        }
        logger.debug("processing server part 1, validation type: {}", (Object)this.validationType);
        int digestOffset = RtmpHandshake.digestOffset(in, this.validationType);
        byte[] expected = RtmpHandshake.digestHandshake(in, digestOffset, SERVER_CONST);
        this.peerPartOneDigest = new byte[32];
        in.getBytes(digestOffset, this.peerPartOneDigest);
        if (!Arrays.equals(this.peerPartOneDigest, expected)) {
            int altValidationType = this.validationType == 1 ? 2 : 1;
            logger.warn("server part 1 validation failed for type {}, will try with type {}", (Object)this.validationType, (Object)altValidationType);
            digestOffset = RtmpHandshake.digestOffset(in, altValidationType);
            expected = RtmpHandshake.digestHandshake(in, digestOffset, SERVER_CONST);
            this.peerPartOneDigest = new byte[32];
            in.getBytes(digestOffset, this.peerPartOneDigest);
            if (!Arrays.equals(this.peerPartOneDigest, expected)) {
                throw new RuntimeException("server part 1 validation failed even for type: " + altValidationType);
            }
            this.validationType = altValidationType;
        }
        logger.info("server part 1 validation success");
        this.peerPublicKey = new byte[128];
        int publicKeyOffset = RtmpHandshake.publicKeyOffset(in, this.validationType);
        in.getBytes(publicKeyOffset, this.peerPublicKey);
        this.initCiphers();
    }

    private void decodeServer2(ChannelBuffer in) {
        if (this.validationType == 0) {
            return;
        }
        logger.debug("processing server part 2 for validation");
        byte[] key = Utils.sha256(this.ownPartOneDigest, SERVER_CONST_CRUD);
        int digestOffset = 1504;
        byte[] expected = RtmpHandshake.digestHandshake(in, digestOffset, key);
        byte[] actual = new byte[32];
        in.getBytes(digestOffset, actual);
        if (!Arrays.equals(actual, expected)) {
            throw new RuntimeException("server part 2 validation failed");
        }
        logger.info("server part 2 validation success");
    }

    public ChannelBuffer encodeClient2() {
        if (this.validationType == 0) {
            this.peerPartOne.setBytes(0, this.peerTime);
            this.peerPartOne.setInt(4, 0);
            return this.peerPartOne;
        }
        logger.debug("creating client part 2 for validation");
        ChannelBuffer out = RtmpHandshake.generateRandomHandshake();
        byte[] key = Utils.sha256(this.peerPartOneDigest, CLIENT_CONST_CRUD);
        int digestOffset = 1504;
        byte[] digest = RtmpHandshake.digestHandshake(out, digestOffset, key);
        out.setBytes(digestOffset, digest);
        return out;
    }

    public void decodeClient0And1(ChannelBuffer in) {
        this.decodeClient0(in.readBytes(1));
        this.decodeClient1(in.readBytes(1536));
    }

    private void decodeClient0(ChannelBuffer in) {
        byte firstByte = in.readByte();
        this.rtmpe = firstByte == 6;
        logger.debug("client first byte {}, rtmpe: {}", (Object)Utils.toHex(firstByte), (Object)this.rtmpe);
    }

    private boolean decodeClient1(ChannelBuffer in) {
        this.peerTime = new byte[4];
        in.getBytes(0, this.peerTime);
        this.peerVersion = new byte[4];
        in.getBytes(4, this.peerVersion);
        logger.debug("client time: {}, version: {}", (Object)Utils.toHex(this.peerTime), (Object)Utils.toHex(this.peerVersion));
        this.validationType = RtmpHandshake.getValidationTypeForClientVersion(this.peerVersion);
        if (this.validationType == 0) {
            this.peerPartOne = in;
            return true;
        }
        logger.debug("processing client part 1 for validation type: {}", (Object)this.validationType);
        this.initKeyPair();
        int digestOffset = RtmpHandshake.digestOffset(in, this.validationType);
        this.peerPartOneDigest = new byte[32];
        in.getBytes(digestOffset, this.peerPartOneDigest);
        byte[] expected = RtmpHandshake.digestHandshake(in, digestOffset, CLIENT_CONST);
        if (!Arrays.equals(this.peerPartOneDigest, expected)) {
            throw new RuntimeException("client part 1 validation failed");
        }
        logger.info("client part 1 validation success");
        int publicKeyOffset = RtmpHandshake.publicKeyOffset(in, this.validationType);
        this.peerPublicKey = new byte[128];
        in.getBytes(publicKeyOffset, this.peerPublicKey);
        this.initCiphers();
        return true;
    }

    public ChannelBuffer encodeServer0() {
        ChannelBuffer out = ChannelBuffers.buffer((int)1);
        out.writeByte((byte)(this.rtmpe ? 6 : 3));
        return out;
    }

    public ChannelBuffer encodeServer1() {
        ChannelBuffer out = RtmpHandshake.generateRandomHandshake();
        out.setInt(0, 0);
        out.setBytes(4, this.serverVersionToUse);
        if (this.validationType == 0) {
            this.ownPartOne = out.copy();
            return out;
        }
        logger.debug("creating server part 1 for validation type: {}", (Object)this.validationType);
        int publicKeyOffset = RtmpHandshake.publicKeyOffset(out, this.validationType);
        out.setBytes(publicKeyOffset, this.ownPublicKey);
        int digestOffset = RtmpHandshake.digestOffset(out, this.validationType);
        this.ownPartOneDigest = RtmpHandshake.digestHandshake(out, digestOffset, SERVER_CONST);
        out.setBytes(digestOffset, this.ownPartOneDigest);
        return out;
    }

    public void decodeClient2(ChannelBuffer raw) {
        ChannelBuffer in = raw.readBytes(1536);
        if (this.validationType == 0) {
            return;
        }
        logger.debug("processing client part 2 for validation");
        byte[] key = Utils.sha256(this.ownPartOneDigest, CLIENT_CONST_CRUD);
        int digestOffset = 1504;
        byte[] expected = RtmpHandshake.digestHandshake(in, digestOffset, key);
        byte[] actual = new byte[32];
        in.getBytes(digestOffset, actual);
        if (!Arrays.equals(actual, expected)) {
            throw new RuntimeException("client part 2 validation failed");
        }
        logger.info("client part 2 validation success");
    }

    public ChannelBuffer encodeServer2() {
        if (this.validationType == 0) {
            this.peerPartOne.setBytes(0, this.peerTime);
            this.peerPartOne.setInt(4, 0);
            return this.peerPartOne;
        }
        logger.debug("creating server part 2 for validation");
        ChannelBuffer out = RtmpHandshake.generateRandomHandshake();
        byte[] key = Utils.sha256(this.peerPartOneDigest, SERVER_CONST_CRUD);
        int digestOffset = 1504;
        byte[] digest = RtmpHandshake.digestHandshake(out, digestOffset, key);
        out.setBytes(digestOffset, digest);
        return out;
    }

    static {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(151026690, 1);
        map.put(151033602, 1);
        map.put(151035650, 1);
        map.put(151057922, 1);
        map.put(0xA000202, 1);
        map.put(167775234, 1);
        map.put(-2147483390, 1);
        map.put(-2147482878, 2);
        map.put(0xA002002, 2);
        clientVersionToValidationTypeMap = map;
    }
}

