/*
 * Decompiled with CFR 0.152.
 */
package com.flazr.rtmp;

import com.flazr.rtmp.RtmpMessage;
import com.flazr.rtmp.RtmpReader;
import com.flazr.rtmp.message.Metadata;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopedReader
implements RtmpReader {
    private static final Logger logger = LoggerFactory.getLogger(LoopedReader.class);
    private final int loopCount;
    private final RtmpReader reader;
    private long timePosition;
    private double duration = -1.0;
    private int loopsCompleted = 0;
    private final Metadata metadata;
    private RtmpMessage[] startMessages;

    public LoopedReader(RtmpReader reader, int loopCount) {
        this.reader = reader;
        this.loopCount = loopCount;
        this.metadata = reader.getMetadata();
        double originalDuration = this.metadata.getDuration();
        if (originalDuration > 0.0) {
            double durationSeconds = originalDuration * (double)loopCount;
            this.metadata.setDuration(durationSeconds);
        } else {
            this.metadata.setDuration(-1.0);
        }
        logger.info("looped reader init: count {}", (Object)loopCount);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public RtmpMessage[] getStartMessages() {
        if (this.startMessages == null) {
            ArrayList<RtmpMessage> list = new ArrayList<RtmpMessage>();
            list.add(this.metadata);
            for (RtmpMessage message : this.reader.getStartMessages()) {
                if (message.getHeader().isMetadata()) continue;
                list.add(message);
            }
            this.startMessages = list.toArray(new RtmpMessage[list.size()]);
        }
        return this.startMessages;
    }

    public void setAggregateDuration(int targetDuration) {
        this.reader.setAggregateDuration(targetDuration);
    }

    public long getTimePosition() {
        return this.timePosition;
    }

    public long seek(long timePosition) {
        if (this.duration < 0.0 || (double)timePosition < this.duration) {
            return this.reader.seek(timePosition);
        }
        this.loopsCompleted = (int)Math.floor((double)timePosition / this.duration);
        return this.reader.seek((long)((double)timePosition % this.duration));
    }

    public void close() {
        this.reader.close();
    }

    public boolean hasNext() {
        if (this.reader.hasNext()) {
            return true;
        }
        if (this.loopsCompleted == 0 && this.duration == -1.0) {
            this.duration = this.timePosition;
        }
        ++this.loopsCompleted;
        if (this.loopsCompleted < this.loopCount) {
            this.reader.seek(0L);
            logger.info("re-wound media after loop #{}", (Object)this.loopsCompleted);
            return true;
        }
        return false;
    }

    public RtmpMessage next() {
        RtmpMessage message = this.reader.next();
        if (this.loopsCompleted == 0) {
            this.timePosition = message.getHeader().getTime();
            return message;
        }
        this.timePosition = (long)this.duration * (long)this.loopsCompleted + (long)message.getHeader().getTime();
        message.getHeader().setTime((int)this.timePosition);
        return message;
    }
}

